% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asca_results.R
\name{asca_results}
\alias{asca_results}
\alias{print.asca}
\alias{summary.asca}
\alias{projections}
\alias{projections.asca}
\alias{print.summary.asca}
\alias{loadings.asca}
\alias{scores.asca}
\title{ASCA Result Methods}
\usage{
\method{print}{asca}(x, ...)

\method{summary}{asca}(object, ...)

\method{print}{summary.asca}(x, digits = 2, ...)

\method{loadings}{asca}(object, factor = 1, ...)

\method{scores}{asca}(object, factor = 1, ...)

projections(object, ...)

\method{projections}{asca}(object, factor = 1, ...)
}
\arguments{
\item{x}{\code{asca} object.}

\item{...}{additional arguments to underlying methods.}

\item{object}{\code{asca} object.}

\item{digits}{\code{integer} number of digits for printing.}

\item{factor}{\code{integer/character} for selecting a model factor.}
}
\value{
Returns depend on method used, e.g. \code{projections.asca} returns projected samples,
\code{scores.asca} return scores, while print and summary methods return the object invisibly.
}
\description{
Standard result computation and extraction functions for ASCA (\code{\link{asca}}).
}
\details{
Usage of the functions are shown using generics in the examples in \code{\link{asca}}.
Explained variances are available (block-wise and global) through \code{blockexpl} and \code{print.rosaexpl}.
Object printing and summary are available through:
\code{print.asca} and \code{summary.asca}.
Scores and loadings have their own extensions of \code{scores()} and \code{loadings()} through
\code{scores.asca} and \code{loadings.asca}. Special to ASCA is that scores are on a
factor level basis, while back-projected samples have their own function in \code{projections.asca}.
}
\references{
\itemize{
\item Smilde, A., Jansen, J., Hoefsloot, H., Lamers,R., Van Der Greef, J., and Timmerman, M.(2005). ANOVA-Simultaneous Component Analysis (ASCA): A new tool for analyzing designed metabolomics data. Bioinformatics, 21(13), 3043–3048.
\item Liland, K.H., Smilde, A., Marini, F., and Næs,T. (2018). Confidence ellipsoids for ASCA models based on multivariate regression theory. Journal of Chemometrics, 32(e2990), 1–13.
\item Martin, M. and Govaerts, B. (2020). LiMM-PCA: Combining ASCA+ and linear mixed models to analyse high-dimensional designed data. Journal of Chemometrics, 34(6), e3232.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for plotting are found in \code{\link{asca_plots}}.
}
