% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sopls_pm.R
\name{SO_TDI}
\alias{SO_TDI}
\alias{sopls_pm}
\alias{print.SO_TDI}
\alias{sopls_pm_multiple}
\alias{print.SO_TDI_multiple}
\title{Total, direct, indirect and additional effects in SO-PLS-PM.}
\usage{
sopls_pm(
  X,
  Y,
  ncomp,
  max_comps = min(sum(ncomp), 20),
  sel.comp = "opt",
  computeAdditional = FALSE,
  sequential = FALSE,
  B = NULL,
  k = 10,
  type = "consecutive"
)

\method{print}{SO_TDI}(x, showComp = TRUE, heading = "SO-PLS path effects", digits = 2, ...)

sopls_pm_multiple(
  X,
  ncomp,
  max_comps = min(sum(ncomp), 20),
  sel.comp = "opt",
  computeAdditional = FALSE,
  sequential = FALSE,
  B = NULL,
  k = 10,
  type = "consecutive"
)

\method{print}{SO_TDI_multiple}(x, heading = "SO-PLS path effects", digits = 2, ...)
}
\arguments{
\item{X}{A \code{list} of input blocks (of type \code{matrix}).}

\item{Y}{A \code{matrix} of response(s).}

\item{ncomp}{An \code{integer} vector giving the number of components per block or a single integer for common number of components.}

\item{max_comps}{Maximum total number of components.}

\item{sel.comp}{A \code{character} or \code{integer} vector indicating the type ("opt" - minimum error / "chi" - chi-squared reduced) or exact number of components in selections.}

\item{computeAdditional}{A \code{logical} indicating if additional components should be computed.}

\item{sequential}{A \code{logical} indicating if sequential component optimization should be applied.}

\item{B}{An \code{integer} giving the number of bootstrap replicates for variation estimation.}

\item{k}{An \code{integer} indicating number of cross-validation segments (default = 10).}

\item{type}{A \code{character} for selecting type of cross-validation segments (default = "consecutive").}

\item{x}{An object of type \code{SO_TDI}.}

\item{showComp}{A \code{logical} indicating if components should be shown in print (default = TRUE).}

\item{heading}{A \code{character} giving the heading of the print.}

\item{digits}{An \code{integer} for selecting number of digits in print.}

\item{...}{Not implemented}
}
\value{
An object of type \code{SO_TDI} containing total, direct and indirect effects, plus
possibly additional effects and standard deviations (estimated by bootstrapping).
}
\description{
SO-PLS-PM is the use of SO-PLS for path-modelling. This particular function
is used to compute effects (explained variances) in sub-paths of the directed acyclic graph.
}
\details{
\code{sopls_pm} computes 'total', 'direct', 'indirect' and 'additional' effects for the 'first' versus the
'last' input block by cross-validated explained variances. 'total' is the explained variance when doing
regression of 'first' -> 'last'. 'indirect' is the the same, but controlled for the intermediate blocks.
'direct' is the left-over part of the 'total' explained variance when subtracting the 'indirect'. Finally,
'additional' is the added explained variance of 'last' for each block following 'first'.

\code{sopls_pm_multiple} is a wrapper for \code{sopls_pm} that repeats the calculation for all pairs of blocks
from 'first' to 'last'. Where \code{sopls_pm} has a separate response, Y, signifying the 'last' block,
\code{sopls_pm_multiple} has multiple 'last' blocks, depending on sub-path, thus collects the response(s)
from the list of blocks X.

When sel.comp = "opt", the number of components for all models are optimized using cross-validation
within the ncomp and max_comps supplied. If sel.comp is "chi", an optimization is also performed,
but parsimonious solutions are sought through a chi-square chriterion. When setting sel.comp to a
numeric vector, exact selection of number of components is performed.

When setting B to a number, e.g. 200, the procedures above are repeated B times using bootstrapping
to estimate standard deviations of the cross-validated explained variances.
}
\examples{
# Single path for the potato data:
data(potato)
pot.pm <- sopls_pm(potato[1:3], potato[['Sensory']], c(5,5,5), computeAdditional=TRUE)
pot.pm

# Corresponding SO-PLS model:
# so <- sopls(Sensory ~ ., data=potato[c(1,2,3,9)], ncomp=c(5,5,5), validation="CV", segments=10)
# maageSeq(pot.so, compSeq = c(3,2,4))

# All path in the forward direction for the wine data:
data(wine)
pot.pm.multiple <- sopls_pm_multiple(wine, ncomp = c(4,2,9,8))
pot.pm.multiple
}
\references{
\itemize{
\item Menichelli, E., Almøy, T., Tomic, O., Olsen, N. V., & Næs, T. (2014). SO-PLS as an exploratory tool for path modelling. Food quality and preference, 36, 122-134.
\item Næs, T., Romano, R., Tomic, O., Måge, I., Smilde, A., & Liland, K. H. (2020). Sequential and orthogonalized PLS (SO-PLS) regression for path analysis: Order of blocks and relations between effects. Journal of Chemometrics, e3243.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
}
