% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitBall_normGauss.R
\docType{class}
\name{unitBall_normGauss-class}
\alias{unitBall_normGauss-class}
\alias{unitBall_normGauss}
\title{An S4 class to represent the function \eqn{\frac{1}{(2\pi)^{n/2}}\exp(-\Vert\vec{x}\Vert_2^2/2)} on \eqn{B^{n}}}
\description{
Implementation of the function
\deqn{f \colon B_n \to [0,\infty),\, \vec{x} \mapsto f(\vec{x}) = \frac{1}{(2\pi)^{n/2}}\exp(-\Vert\vec{x}\Vert_2^2/2) = \frac{1}{(2\pi)^{n/2}}\exp(-\frac{1}{2}\sum_{i=1}^n x_i^2),}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{B_n = \{\vec{x}\in R^n : \Vert \vec{x} \Vert_2 \leq 1\}}.
In this case the integral is know to be
\deqn{\int_{B_n} f(\vec{x}) d\vec{x} = P[Z \leq 1] = F_{\chi^2_n}(1),}
where \eqn{Z} follows a chisquare distribution with \eqn{n} degrees of freedom.
}
\details{
The instance needs to be created with one parameter representing \eqn{n}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}
}}

\examples{
n <- as.integer(3)
f <- new("unitBall_normGauss",dim=n)
}
\author{
Klaus Herrmann
}
