% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ns_climate}
\alias{ns_climate}
\title{Nova Scotia Long-Term Climate Data}
\format{A \link{mudata} object}
\source{
Environment Canada via the 'rclimateca' package. \url{http://climate.weather.gc.ca/}
}
\usage{
ns_climate
}
\description{
Monthly climate data for locations in Nova Scotia with records longer than 80 years.
}
\examples{
print(ns_climate)
autoplot(ns_climate) # quite a messy plot, lots of data

# a more focused plot comparing three locations
library(lubridate)
ns_climate \%>\% 
  select_locations(sable_island = starts_with("SABLE"),
                   nappan = starts_with("NAPPAN"), 
                   baddeck = starts_with("BADDECK")) \%>\% 
  select_params(ends_with("temp")) \%>\%
  filter_data(month(date) == 6) \%>\% 
  autoplot()

}
\keyword{datasets}
