% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtrank.R
\name{mtrank}
\alias{mtrank}
\alias{print.mtrank}
\title{Estimate the treatment hierarchy in network meta-analysis using a
probabilistic ranking model}
\usage{
mtrank(x, reference.group = NULL, level = x$level)

\method{print}{mtrank}(
  x,
  sorting = "ability",
  backtransf = FALSE,
  digits = gs("digits"),
  digits.prop = gs("digits.prop"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{tcc}} or \code{\link{mtrank}}
(print function).}

\item{reference.group}{An argument specifying the reference group. If set to
NULL (default), ability estimates of all treatments will be calculated.
If some treatment is set as the reference group, relative abilities of all
treatments versus the specified reference treatment will be calculated.}

\item{level}{The level used to calculate confidence intervals for ability
estimates.}

\item{sorting}{An argument specifying the criterion to sort the ability
estimates in the printout (see Details).}

\item{backtransf}{A logical argument specifying whether to show log-ability
estimates (\code{FALSE}, default) or on the natural scale (\code{TRUE}).}

\item{digits}{Minimal number of significant digits for ability estimates,
see \code{print.default}.}

\item{digits.prop}{Minimal number of significant digits for proportions,
see \code{print.default}.}

\item{\dots}{Additional arguments (passed on to \code{\link{prmatrix}}).}
}
\value{
\itemize{
\item A data frame containing the resulting log-ability estimates, their
  standard errors and their confidence intervals.
\item The estimate of the tie prevalence parameter v.
\item The normalized ability estimates for each treatment. 
}
}
\description{
This function fits the Bradley-Terry ranking model and produces a treatment
hierarchy based on the method described by Evrenoglou et al. (2024) for
network meta-analysis.
}
\details{
This function is used to fit a Bradley-Terry model to the paired-preference
data generated from the treatment choice criterion constructed by the
\code{\link{tcc}} function. This function estimates the ability of
each treatment in the network and the respective standard errors and
confidence intervals using the maximum likelihood approach. To retain
identifiability, the maximization of the log-likelihood takes place subject
to the constrain that the ability estimates sum to 1. Then, the maximum
likelihood estimates (MLEs) are calculated iteratively.
Note that the final estimates of the ability parameters are not necessarily
needed to sum to 1 as after the first iteration of the algorithm the ability
estimates are not normalized. However, by normalizing the final ability
estimates to sum up to 1 these can be interpreted as "the probability that
each treatment is having the highest ability".

Finally, a parameter "v" controlling the prevalence of ties in the network
is also estimated. Although the estimated values of this parameter do
not have a direct interpretation they are useful for estimating pairwise 
probabilities (see \code{\link{paired_pref}}).

If argument \code{reference.group} is not NULL, a reference treatment
group is specified. Mathematically, this means that the maximization problem
is now identifiable, subject to the condition that the ability of this
treatment is 0. Then, the resulting MLEs are the relative abilities of all
treatments in the network versus the specified reference treatment group.
Note that the estimates of the parameter "v" and the normalized probabilities
do not depend on the value for argument \code{reference.group}.
}
\examples{
data(Stowe2010, package = "netmeta")
#
ranks <- tcc(treat = list(t1, t2, t3), studlab = study, 
  mean = list(y1, y2, y3), n = list(n1, n2, n3), sd = list(sd1, sd2, sd3), 
  data = Stowe2010, sm = "MD", small.values = "desirable", mcid = 0.5)
#
fit <- mtrank(ranks)
# Print log-ability estimates
fit
# Print ability estimates
print(fit, backtransf = TRUE)

}
\references{
Evrenoglou T, Nikolakopoulou A, Schwarzer G, Rücker G, Chaimani A (2024):
Producing treatment hierarchies in network meta-analysis using probabilistic
models and treatment-choice criteria.
\url{https://arxiv.org/abs/2406.10612}
}
