% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{powerPlot}
\alias{powerPlot}
\title{Plot the power curve(s) for the given design(s)}
\usage{
powerPlot(grid, probs = seq(0, 1, 0.01))
}
\arguments{
\item{grid}{the tibble containing the designs to be
plotted}

\item{probs}{the response rates for which the rejection probabilities are to
be plotted}
}
\value{
the ggplot object containing the power curve(s)
}
\description{
Plot the power curve(s) for the given design(s)
}
\examples{
createGrid(p0 = 0.05, p1 = 0.25, alpha = 0.05, beta = 0.2, mander = FALSE) \%>\%
  augmentGrid(cores = 2) \%>\%
  obtainDesign() \%>\%
  powerPlot(probs = seq(0, 0.5, 0.025))
}
