% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviceXML.R
\name{get_device_info_from_xml}
\alias{get_device_info_from_xml}
\title{Get info on all the devices in the xml file}
\usage{
get_device_info_from_xml(file_path_xml, mtconnect_version = NULL)
}
\arguments{
\item{file_path_xml}{Path to the XML file}

\item{mtconnect_version}{Specify MTConnect Version manually. If not specified, it is inferred automatically from the data.}
}
\description{
Device XML usually consists of the configuration details of multiple devices. This
function can detail all the device info in the XML into a data.frame for easy reference
}
\examples{
file_path_xml = "testdata/dataExtraction/test_devices.xml"
devices_info = get_device_info_from_xml(system.file(file_path_xml, package = "mtconnectR"))
print(devices_info)

}
\seealso{
\code{\link{get_xpaths_from_xml}}
}

