% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_axis.R
\name{trans_composition}
\alias{trans_composition}
\title{Transformation for continuous data with a finite number of distinct values}
\usage{
trans_composition(x = NULL, nb = 30, brk = NA, dab = NA, dgrd = NA, dgrd2 = NA)
}
\arguments{
\item{x}{A numerical vector used in a plot as (typically) \code{x}}

\item{nb}{An integer for the maximum number of breaks. Default=30}

\item{brk}{One of
\itemize{
  \item A numerical value within \code{range(x)}. All values after the value will be spaced equally
  \item \code{NA} or a numerical value that is greater than or equal to \code{max(x)}. All values will be plotted in the original scale
  \item A numerical value that is smaller than or equal to \code{max(x)}. All values will be plotted in equal space
}}

\item{dab}{One of
\itemize{
  \item NA for a value calculated automatically
  \item A number for the distance after \code{brk}
}}

\item{dgrd}{One of
\itemize{
  \item NA for a value calculated automatically
  \item A number for the minimum space between major grids
}}

\item{dgrd2}{One of
\itemize{
  \item NA for a value calculated automatically
  \item A number for the minimum space between major grids
}}
}
\value{
A transformation function
}
\description{
\code{trans_composition()} derives a transformation from a numerical vector with a smaller number (ideally < 30) of distinct values.
The return can be used with function \code{ggplot::scale_x_continuous()}
or \code{ggplot::scale_y_continuous()} to create a desired axis.
}
\examples{
library(ggplot2)
pdt=data.frame(x=rep(c(0.5, 1, 10,11,12, 100, 1000), each=5))
pdt$y=pdt$x+rnorm(length(pdt$x))
t=trans_composition(pdt$x,brk=50, dab=3)
ggplot(pdt, aes(x=x, y=y))+geom_point()+scale_x_continuous(trans=t)

}
