% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsims.R
\docType{methods}
\name{plot_mrgsims}
\alias{plot_mrgsims}
\alias{plot,mrgsims,missing-method}
\alias{plot,mrgsims,formula-method}
\title{Generate a quick plot of simulated data}
\usage{
\S4method{plot}{mrgsims,missing}(x, limit = 16, ...)

\S4method{plot}{mrgsims,formula}(x, y, limit = 16, show.grid = TRUE,
  outer = TRUE, type = "l", lwd = 2, ylab = "value", groups = ID,
  scales = list(y = list(relation = "free")), logy = FALSE,
  logbr = 3, ...)
}
\arguments{
\item{x}{mrgsims object}

\item{limit}{limit the the number of panels to create}

\item{...}{other arguments passed to xyplot}

\item{y}{formula used for plotting}

\item{show.grid}{logical indicating whether or not to draw panel.grid}

\item{outer}{passed to xyplot}

\item{type}{passed to xyplot}

\item{lwd}{passed to xyplot}

\item{ylab}{passed to xyplot}

\item{groups}{passed to xyplot}

\item{scales}{passed to xyplot}

\item{logy}{plot the y variables on log scale}

\item{logbr}{log scale breaks indicator; use \code{1} for breaks every log
unit; use \code{3} for breaks every half log unit; use \code{0} for default
breaks}
}
\description{
Generate a quick plot of simulated data
}
\examples{

mod <- mrgsolve:::house(end=48, delta=0.2) \%>\% init(GUT=1000)

out <- mrgsim(mod)

plot(out)

plot(out, subset=time <=24)

plot(out, GUT+CP~.)

plot(out, CP+RESP~time, col="black", scales="same", lty=2)

}
