% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_set.R
\docType{methods}
\name{data_set}
\alias{data_set}
\alias{data_set,mrgmod,data.frame-method}
\alias{data_set,mrgmod,ANY-method}
\alias{data_set,mrgmod,ev-method}
\alias{data_set,mrgmod,missing-method}
\title{Select and modify a data set for simulation}
\usage{
data_set(x, data, ...)

\S4method{data_set}{mrgmod,data.frame}(x, data, .subset = TRUE,
  .select = TRUE, object = NULL, need = NULL, ...)

\S4method{data_set}{mrgmod,ANY}(x, data, ...)

\S4method{data_set}{mrgmod,ev}(x, data, ...)

\S4method{data_set}{mrgmod,missing}(x, object, ...)
}
\arguments{
\item{x}{model object}

\item{data}{data set}

\item{...}{passed along}

\item{.subset}{an unquoted expression passed to 
\code{dplyr::filter}; retain only certain rows in the data set}

\item{.select}{passed to \code{dplyr::select}; retain only certain 
columns in the data set; this should be the result of a call to 
\code{dplyr::vars()}}

\item{object}{character name of an object existing in \code{$ENV} 
to use for the data set}

\item{need}{passed to \code{\link{inventory}}}
}
\description{
Select and modify a data set for simulation
}
\details{
Input data sets are \code{R} data frames that can include columns 
with any valid name, however columns with selected names are 
treated specially by \code{mrgsolve} and incorporated into the 
simulation.

\code{ID} specifies the subject ID and is required for every 
input data set.

When columns have the same name as parameters (\code{$PARAM} in 
the model specification file), the values in those columns will 
be used to update the corresponding parameter as the simulation 
progresses.

Input data set may include the following columns related to 
PK dosing events: \code{time}, \code{cmt}, \code{amt}, \code{rate},
\code{ii}, \code{addl}, \code{ss}.  \code{time} and \code{cmt} 
(and \code{ID}) are required columns in the input data set. 
\code{time} is the observation or event time, \code{cmt} 
is the compartment number (see \code{\link{init}}), \code{amt} 
is the dosing amount, \code{rate} is the infusion rate, 
\code{ii} is the dosing interval, \code{addl} specifies 
additional doses to administer, and \code{ss} is a flag 
for steady state dosing.  These column names operate 
similarly to other non-linear mixed effects modeling 
software.  Upper case PK dosing column names including
\code{TIME}, \code{CMT}, \code{AMT}, \code{RATE}, \code{II},
\code{ADDL}, \code{SS} are also recognized.  However, an 
error will be generated if a mix of upper case and lower
case columns are found.

Only numeric data can be brought in to the problem.  
Any non-numeric data columns will be dropped with warning.

See \code{\link{exdatasets}} for different example data sets.
}
\examples{

mod <- mrgsolve:::house()

data <- expand.ev(ID=1:3, amt=c(10,20))

mod \%>\% data_set(data, ID > 1) \%>\% mrgsim

data(extran1)
head(extran1)

mod \%>\% data_set(extran1) \%>\% mrgsim
mod \%>\% mrgsim(data=extran1)

}
\seealso{
\code{\link{idata_set}}, \code{\link{ev}}, 
\code{\link{valid_data_set}}, \code{\link{valid_idata_set}}
}
