% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{new_stream}
\alias{new_stream}
\alias{new_stream.list}
\alias{new_stream.numeric}
\alias{new_stream.character}
\title{Create a stream of outputs and inputs}
\usage{
new_stream(x, ...)

\method{new_stream}{list}(x, locker = NULL, format = NULL, ...)

\method{new_stream}{numeric}(x, ...)

\method{new_stream}{character}(x, ...)
}
\arguments{
\item{x}{A list or vector to template the stream; for the \code{numeric} method,
passing a single number will fill \code{x} with a sequence of that length.}

\item{...}{Additional arguments passed to \code{\link[=file_set]{file_set()}}.}

\item{locker}{Passed to \code{\link[=setup_locker]{setup_locker()}} as \code{dir}; important to note that the
directory will be unlinked if it exists and is an established locker
directory.}

\item{format}{Passed to \code{\link[=format_stream]{format_stream()}}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{i} the position number
\item \code{file} the output file name
\item \code{x} the input object.
}

The list has class \code{file_stream} as well as \code{locker_stream} (if \code{locker} was
passed) and a class attribute for the output if \code{format} was passed.
}
\description{
By stream we mean a list that pre-specifies the output file names,
replicate numbers and possibly input objects for a simulation. Passing
\code{locker} initiates a call to \code{\link[=setup_locker]{setup_locker()}}, which sets up or resets
the output directories.
}
\examples{
x <- new_stream(3)
x[[1]]

new_stream(2, locker = file.path(tempdir(), "foo"))

df <- data.frame(ID = c(1,2,3,4))
data <- chunk_by_id(df, nchunk = 2)
x <- new_stream(data)
x[[2]]

format_is_set(x[[2]])
x <- new_stream(3, format = "fst")
format_is_set(x[[2]])

}
\seealso{
\code{\link[=format_stream]{format_stream()}}, \code{\link[=locate_stream]{locate_stream()}}, \code{\link[=ext_stream]{ext_stream()}}, \code{\link[=file_stream]{file_stream()}},
\code{\link[=file_set]{file_set()}}
}
