% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_likelihood.R
\name{pl_mrf2d}
\alias{pl_mrf2d}
\title{Pseudo-likelihood function for MRFs on 2d lattices}
\usage{
pl_mrf2d(Z, mrfi, theta, log_scale = TRUE)
}
\arguments{
\item{Z}{A \code{matrix} with integers in \verb{\{0,...,C\}}.}

\item{mrfi}{A \code{\link[=mrfi-class]{mrfi}} object representing the
interaction structure.}

\item{theta}{A 3-dimensional array describing potentials. Slices represent
interacting positions, rows represent pixel values and columns represent
neighbor values. As an example: \code{theta[1,3,2]} has the potential for the
pair of values 0,2 observed in the second relative position of \code{mrfi}.}

\item{log_scale}{A \code{logical} value indicating whether the returned value
should be in logarithmic scale.}
}
\value{
A \code{numeric} with the pseudo-likelihood value.
}
\description{
Computes the pseudo-likelihood function of a Markov Random Field
on a 2-dimensional lattice.
}
\details{
The pseudo-likelihood function is defined as the product of
conditional probabilities of each pixel given its neighbors:

\deqn{\prod_i P(Z_i | Z_{{N}_i}, \theta).}
}
\examples{
pl_mrf2d(Z_potts, mrfi(1), theta_potts)

}
\seealso{
A paper with detailed description of the package can be found at
\url{https://arxiv.org/abs/2006.00383}
}
\author{
Victor Freguglia
}
