% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_mrp_get.R
\name{mrp_col_unique}
\alias{mrp_col_unique}
\alias{mrp_col_distinct}
\title{Get all the possible values of a column of a Marine Regions data product}
\usage{
mrp_col_unique(layer, colname)

mrp_col_distinct(layer, colname)
}
\arguments{
\item{layer}{(character) Identifier of the data product. See \link{mrp_list}}

\item{colname}{(character) Column name in the data product. See \code{\link[=mrp_colnames]{mrp_colnames()}}}
}
\value{
A numeric or character vector with the unique values of a column of a Marine Regions data product.
}
\description{
Get all the possible values of a column of a Marine Regions data product
}
\details{
This function becomes useful to write CQL or OGC filters that you can pass to \code{\link[=mrp_get]{mrp_get()}} or \code{\link[=mrp_view]{mrp_view()}} as
it helps to know all the possible values in the column name that you want to query on beforehand. Use it
together with \code{\link[=mrp_colnames]{mrp_colnames()}} to know the columns and data types in the data product.
\subsection{Geometry columns}{

Note that columns of type \code{geometry} are forbidden as their performance is sub-optimal and would likely
crash your R session.
}
}
\examples{
\donttest{
mrp_col_unique("ecs", "pol_type")
mrp_col_unique("ecs_boundaries", "line_type")
}
}
\seealso{
\link{mrp_list} to describe the list of products, \code{\link[=mrp_colnames]{mrp_colnames()}} to get the names and data type of
the columns of a data product, useful to write queries that can be passed to \code{\link[=mrp_get]{mrp_get()}} or \code{\link[=mrp_view]{mrp_view()}} via
the arguments \code{cql_filter} or \code{filter}.
}
