% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mr_ivw_rjags.R
\name{mr_ivw_rjags}
\alias{mr_ivw_rjags}
\title{Bayesian inverse variance weighted model with a choice of prior distributions fitted using JAGS.}
\usage{
mr_ivw_rjags(
  object,
  prior = "default",
  betaprior = "",
  n.chains = 3,
  n.burn = 1000,
  n.iter = 5000,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{A data object of class \code{\link{mr_format}}.}

\item{prior}{A character string for selecting the prior distributions;
\itemize{
\item \code{"default"} selects a non-informative set of priors;
\item \code{"weak"} selects weakly informative priors;
\item \code{"pseudo"} selects a pseudo-horseshoe prior on the causal effect.
}}

\item{betaprior}{A character string in JAGS syntax to allow a user defined prior for the causal effect.}

\item{n.chains}{Numeric indicating the number of chains used in the MCMC estimation, the default is \code{3} chains.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian MCMC estimation. The default is \code{1000} samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian MCMC estimation. The default is \code{5000} iterations.}

\item{seed}{Numeric indicating the random number seed. The default is the rjags default.}

\item{...}{Additional arguments passed through to \code{\link[rjags:jags.model]{rjags::jags.model()}}.}
}
\value{
An object of class \code{ivwjags} containing the following components:
\describe{
\item{CausalEffect}{The mean of the simulated causal effects}
\item{StandardError}{Standard deviation of the simulated causal effects}
\item{CredibleInterval}{The credible interval for the causal effect, which indicates the lower(2.5\%), median (50\%) and upper intervals (97.5\%)}
\item{samples}{Output of the Bayesian MCMC samples with the different chains}
\item{Priors}{The specified priors}
}
}
\description{
Bayesian inverse variance weighted model with a choice of prior distributions fitted using JAGS.
}
\examples{
fit <- mr_ivw_rjags(bmi_insulin)
print(fit)
summary(fit)
plot(fit$samples)
# 90\% credible interval
fitdf <- do.call(rbind.data.frame, fit$samples)
cri90 <- quantile(fitdf$Estimate, probs = c(0.05,0.95))
print(cri90)

}
\references{
Burgess, S., Butterworth, A., Thompson S.G. Mendelian randomization analysis with multiple genetic variants using summarized data. Genetic Epidemiology, 2013, 37, 7, 658-665 \doi{10.1002/gepi.21758}.
}
