% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mpitb.R
\name{summary.cotframe}
\alias{summary.cotframe}
\title{Summary function of the estimates of the changes over time measures}
\usage{
\method{summary}{cotframe}(object, ...)
}
\arguments{
\item{object}{the "cotframe"-class object}

\item{...}{other arguments}
}
\value{
summary.cotframe a list of summary information for the estimated AF measure
}
\description{
Summary function of the estimates of the changes over time measures
}
\details{
The \code{summary} method for "cotframe"-class objects with coefficients, standard
errors and the corresponding t-values and the p-value for a two sided test,
\eqn{H_0: \beta = 0} being \eqn{\beta} any measure, with the 'significance stars'.
This method work for only one measure \code{c("M0","H","A","hd","hdk")} and either
relative or absolute measure, either non-annualized and annualized measure and only one
poverty cut-off.
Then, user should subset the data frame to obtain the desired summary.
}
\examples{
library(mpitbR)

data <- subset(syn_cdta)
data <- na.omit(data)

svydata <- survey::svydesign(id=~psu, weights = ~weight, strata = ~stratum, data = data)

indicators <- list(d1 = c("d_nutr","d_cm"),
                   d2 = c("d_satt","d_educ"),
                   d3 = c("d_elct","d_sani","d_wtr","d_hsg","d_ckfl","d_asst"))

# Specify mpitb project
set <- mpitb.set(svydata, indicators = indicators, name = "myname", desc = "pref. desc")

# Estimate the cross-sectional MPI and compare non-annualized changes over time
est <- mpitb.est(set, klist = c(33), measures = "M0", indmeasures = NULL,
                 tvar = "t", cotmeasures = "M0",
                 weights = "equal", over = c("area"))

coef(subset(est$lframe, measure == "M0" & t == 1))
confint(subset(est$lframe, measure == "M0" & t == 1))
summary(subset(est$lframe, measure == "M0" & t == 1))

coef(subset(est$cotframe, measure == "M0"))
confint(subset(est$cotframe, measure == "M0"))
summary(subset(est$cotframe, measure == "M0" & ctype == "abs" & ann == 0 & k == 33))
}
\seealso{
\code{coef}, and \code{confint} methods, and \code{mpitb.est} function.
}
\author{
Ignacio Girela
}
