% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{mt_align}
\alias{mt_align}
\title{Align trajectories.}
\usage{
mt_align(
  data,
  use = "trajectories",
  save_as = use,
  dimensions = c("xpos", "ypos"),
  coordinates = "isotropic",
  align_start = FALSE,
  align_end = FALSE,
  align_side = "no",
  verbose = FALSE
)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character string specifying which trajectory variables
should be used. Can be of length 2 or 3 for two-dimensional or
three-dimensional alignment respectively.}

\item{coordinates}{either a numeric vector of length 4 specifying the xstart,
ystart, xend, yend coordinates of the trajectory start and end points. Can
also be \code{isotropic} (the default) to preserve the coordinates of dim1
and dim2, \code{isotropic-norm} to set the coordinates to
\code{c(0,0,-1,x)} where x is chosen to preserve the aspect ratio of dim1
and dim2, \code{mt} to set coordinates to \code{c(0,0,-1,1.5)}, \code{norm}
to set coordinates  to \code{c(0,0,-1,1)}, and \code{wide} to set
coordinates  to \code{c(0,0,-1,1.2)}. In the three-dimensional case,
\code{coordinates} is a vector of length 6.}

\item{align_start}{boolean specifying whether the start points of all
trajectories should be aligned to the position specified in
\code{coordinates}. See Details.}

\item{align_end}{boolean specifying whether the end points of all trajectories
should be aligned to the position specified in \code{coordinates}. See
Details.}

\item{align_side}{character string specifying whether all trajectories should
be flipped to the left side (\code{left}), the right side (\code{right}),
or not at all (\code{no}). Assumes that first entry in \code{dimensions}
are the x positions.}

\item{verbose}{logical indicating whether function should report its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with aligned
trajectories. Per default, the dimensions in the original trajectory array
will be replaced. If a different trajectory array is specified using
\code{save_as}, a new trajectory array will be created (including only the
aligned dimensions). If a trajectory array was provided directly as
\code{data}, only the aligned trajectories will be returned.
}
\description{
\code{mt_align} aligns trajectories to a common start point, end point, and /
or coordinate system.
}
\details{
If \code{align_start} / \code{align_end} is \code{FALSE}, \code{coordinates}
define the position of the average start / end point across all trajectories.

Note that if the end points of trajectories are not aligned, coordinates
refer to the hypothetical case where all trajectories are mapped to one side.

If \code{align_start} / \code{align_end} is \code{TRUE}, the start / end
point of each trajectory is set to the exact position specified in
\code{coordinates}. \code{align_start} and \code{align_end} can be set
completely independently of one another, i.e., one can align only end points,
only start points, none, or both.

If \code{align_start} is set to \code{"left"} or \code{"right"} trajectories
will be flipped to the lower or upper spectrum of the first dimensions,
respectively. If the first dimension is the x-coordinate this is equivalent
to flipping the trajectories to the left and right side, respectively.
}
\examples{
mt_example <- mt_align(mt_example,
  align_start = TRUE, align_end = TRUE,
  coordinates = 'mt')

}
\seealso{
\link{mt_align_start} for aligning all trajectories to a common
start position.

\link{mt_align_start_end} for aligning all trajectories so that they share
a common initial and final coordinate.

\link{mt_remap_symmetric} for remapping trajectories to one side (or one
quadrant) of the coordinate system.
}
\author{
Dirk U. Wulff
}
