% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{mt_heatmap_ggplot}
\alias{mt_heatmap_ggplot}
\title{Plot trajectory heatmap using ggplot.}
\usage{
mt_heatmap_ggplot(data, use = "trajectories", ...)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{...}{arguments passed to \link{mt_heatmap}.}
}
\description{
\code{mt_heatmap_ggplot} plots high resolution raw trajectory maps. Note that
this function has beta status.
}
\details{
\code{mt_heatmap_ggplot} wraps \link{mt_heatmap_raw} and returns a ggplot 
object containing the plot. In contrast to \code{mt_heatmap_plot} plots 
created by \code{mt_heatmap_ggplot} can be extended using ggplot's \code{+} 
operator. For further details on how the trajectory heatmaps are constructed,
see \link{mt_heatmap_raw}.
}
\examples{
mt_heatmap_ggplot(KH2017, xres=500, n_shades=5,mean_image=0.2)

}
\seealso{
\link{mt_heatmap} for plotting a trajectory heatmap using base plots.
    
\link{mt_diffmap} for plotting trajectory difference-heatmaps.
}
\author{
Felix Henninger

Dirk U. Wulff (\email{dirk.wulff@gmail.com})

Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})
}
