% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_mosaic.R
\name{lsp_mosaic}
\alias{lsp_mosaic}
\title{Creates a raster mosaic}
\usage{
lsp_mosaic(x)
}
\arguments{
\item{x}{Usually the output of the \code{lsp_add_examples()} function}
}
\value{
A \code{stars} object
}
\description{
Creates a raster mosaic by rearranging spatial data for example regions.
See examples.
}
\examples{
\donttest{
# larger data example
library(stars)
library(sf)
landform = read_stars(system.file("raster/landform.tif", package = "motif"))
landform_cove = lsp_signature(landform,
                               type = "cove",
                               window = 200,
                               normalization = "pdf")

landform_dist = lsp_to_dist(landform_cove,
                            dist_fun = "jensen-shannon")

landform_hclust = hclust(landform_dist, method = "ward.D2")
plot(landform_hclust)

clusters = cutree(landform_hclust, k = 6)

landform_grid_sf = lsp_add_clusters(landform_cove, clusters)
plot(landform_grid_sf["clust"])

landform_grid_sf_sel = landform_grid_sf \%>\%
    dplyr::filter(na_prop == 0) \%>\%
    dplyr::group_by(clust) \%>\%
    dplyr::slice_sample(n = 16, replace = TRUE)

landform_grid_sf_sel = lsp_add_examples(x = landform_grid_sf_sel, y = landform)
landform_grid_sf_sel

landform_clust_m = lsp_mosaic(landform_grid_sf_sel)

plot(landform_clust_m)
}
}
