% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosum_test.R
\name{mosum.criticalValue}
\alias{mosum.criticalValue}
\title{MOSUM asymptotic critical value}
\usage{
mosum.criticalValue(n, G.left, G.right, alpha)
}
\arguments{
\item{n}{an integer value for the length of the input data}

\item{G.left, G.right}{integer values for the left and right moving sum bandwidth (G.left, G.right)}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}}
}
\value{
a numeric value for the asymptotic critical value for the MOSUM test
}
\description{
Computes the asymptotic critical value for the MOSUM test.
}
\examples{
x <- testData(lengths = rep(100, 3), means = c(0, 5, -2), sds = rep(1, 3), seed = 1234)$x
m <- mosum(x, G = 40)
par(mfrow = c(2, 1))
plot(m$stat, type = "l", xlab = "Time", ylab = "", main = "mosum")
abline(h = mosum.criticalValue(300, 40, 40, .1), col = 4)
abline(v = m$cpts, col = 2)
plot(m, display = "mosum") # identical plot is produced 
}
