% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persp3D_multiscaleMosum.R
\name{persp3D.multiscaleMosum}
\alias{persp3D.multiscaleMosum}
\title{3D Visualization of multiscale MOSUM statistics}
\usage{
persp3D.multiscaleMosum(x, G, mosum.args = list(),
  threshold = c("critical.value", "custom")[1], alpha = 0.05,
  threshold.function = NULL, expand = 0.2, theta = 120, phi = 20,
  xlab = "G", ylab = "t", zlab = "T/c", ticktype = "detailed",
  clim = c(0, 1 + 2/3), NAcol = "#800000FF", ...)
}
\arguments{
\item{x}{a numeric input data vector}

\item{G}{a symmetric bandwidth grid;
either an object of type \code{multiscale.grid} or an integer vector
of bandwidths}

\item{mosum.args}{a named list containing further arguments
to be parsed to the respective \code{mosum} function calls, see \link[mosum]{mosum}}

\item{threshold}{string indicating which threshold should be used for normalization.
By default, \code{mosum.criticalValue} is used for each bandwidth (with significance
level \code{alpha}). Alternatively, it is possible to parse a user-defined function 
with \code{threshold.function} (see details)}

\item{alpha}{alpha a numeric value for the significance level with
\code{0 <= alpha <= 1}. Use iff \code{threshold="critical.value"}}

\item{threshold.function}{function object of form \code{function(G)}, to compute a
threshold of significance for different bandwidths; use iff \code{threshold="custom"}}

\item{expand}{expansion factor applied to the z coordinates}

\item{theta}{azimuthal angle defining the viewing direction}

\item{phi}{colatitude angle defining the viewing direction}

\item{xlab, ylab, zlab, ticktype}{graphical parameters}

\item{clim, NAcol}{coloring parameters}

\item{...}{Further arguments to be passed to function call of \link[plot3D]{persp3D}}
}
\value{
see \link[plot3D]{persp3D}
}
\description{
3D Visualization of multiscale MOSUM statistics
}
\details{
The visualization is based on \link[plot3D]{persp3D}.
To make the MOSUM statistics of different bandwidths visually comparable, 
they are rescaled.
Rescaling is done either by their respective critical value to significance level \code{alpha}
(iff \code{threshold=="critical.value"}) or by a custom value as given by \code{threshold.function}
(iff \code{threshold=="custom"})
}
\examples{
\dontrun{

#' # If you run the example be aware that this may take some time
print("example may take some time to run")

x <- piecewiseStationary_timeSeries(model="mix")
G <- 10:40
persp3D.multiscaleMosum(x, G, mosum.args=list(boundary.extension=F))
}
}
