% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscaleGrid.R
\name{multiscale.grid}
\alias{multiscale.grid}
\title{Multiscale bandwidth grids}
\usage{
multiscale.grid(bandwidths.left, bandwidths.right = bandwidths.left,
  method = "cartesian", max.unbalance = 4)
}
\arguments{
\item{bandwidths.left}{left parts of the bandwidths}

\item{bandwidths.right}{right parts of the bandwidths}

\item{method}{how the asymmetric bandwidths are created;
possible values are
\itemize{
   \item{"cartesian" create all bandwidths in the Cartesian product of 
          bandwidths.left and bandwidths.right}
   \item{"concatenate" join bandwidths.left and bandwidths.right element-wise} 
}}

\item{max.unbalance}{a numeric value for the maximal ratio between maximal and minimal bandwidth,
\code{1 <= max.unbalance <= Inf}; use iff method="cartesian"}
}
\value{
S3 \code{multiscale.grid} object to be used in the \code{multiscale.grid} function
}
\description{
Create asymmetric bandwidth grids to be used with \code{multiscale.cpts}
}
\examples{
multiscale.grid(c(10,15,30))
multiscale.grid((1:5)*5, max.unbalance=2)
}
