% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{makeObjective}
\alias{makeObjective}
\title{Create ecr Objective Function}
\usage{
makeObjective(
  learner,
  task,
  ps,
  resampling,
  measure = NULL,
  holdout.data = NULL,
  worst.measure = NULL,
  cpo = NULLCPO
)
}
\arguments{
\item{learner}{\verb{[Learner]} A \code{\link[mlr:makeLearner]{Learner}} object to optimize.}

\item{task}{\verb{[Task]} The \code{\link[mlr:Task]{mlr::Task}} object to optimize on.}

\item{ps}{\verb{[ParamSet]} The \code{\link[ParamHelpers:makeParamSet]{ParamSet}} to optimize over, only parameters of the
actual learner.}

\item{resampling}{\verb{[ResampleDesc | ResampleInst | function]} The \code{\link[mlr:makeResampleDesc]{ResampleDesc}} or
\code{\link[mlr:makeResampleInstance]{ResampleInst}} object to use. This may be a function
\code{numeric(1)} -> \code{ResampleDesc}/\code{ResampleInst} which maps fidelity to the resampling to use.
If this is used, then the resampling should be chosen such that an average value, weighted by fidelity,
makes sense. For example, the function could map an integer to a corresponding number of resampling folds
or repetitions.}

\item{measure}{\verb{[Measure | NULL]} The \code{\link[mlr:makeMeasure]{Measure}} to optimize for.
The default is \code{NULL}, which uses the \code{task}'s default \code{Measure}.
If measure needs to be maximized, the measure is multiplied
by -1, to make it a minimization task.}

\item{holdout.data}{\verb{[Task]} Additional data on which to predict each
configuration after training on \code{task}.}

\item{worst.measure}{\verb{[numeric(1)]} worst value for measure to consider,
for dominated hypervolume calculation. Will be extracted from the
given measure if not given, but will raise an error if the extracted
(or given) value is infinite. Measure is multiplied by -1, if measure needs
to be maximized.}

\item{cpo}{\verb{[CPO]} CPO pipeline to apply before feature selection.
(A CPO that should be applied \emph{after} feature selection should already be
part of \code{learner} when given). Care should be taken that the
\code{selector.selection} parameter in \code{ps} has the appropriate length of
the data that \code{cpo} emits.}
}
\value{
\code{function} an objective function for \code{\link[ecr:ecr]{ecr::ecr}}.
}
\description{
Creates an objective function that resamples \code{learner} on \code{task}
with \code{resampling} and measures \code{measure} (optional), together
with the number of features selected.
If measure needs to be maximized, it is multiplied by -1 to make it
a minimization task.

The \code{ParamSet} used to generate individuals for the ecr must include
parameters for \code{learner}, not a \code{logical} parameter with length equal
to \code{getTaskNFeats(task)} for feature selection, as it is automatically added
named as \code{selector.selection}.
It can be accessed via \code{getParamSet()} with the object created by
\code{makeObjective()} as input.

\code{learner} must \emph{not} include a \code{cpoSelector()} applied to it, this
happens automatically within \code{makeObjective}.
}
\examples{
library("mlr")
library("rpart")

task.whole <- bh.task
rows.whole <- sample(nrow(getTaskData(task.whole)))
task <- subsetTask(task.whole, rows.whole[1:250])
task.hout <- subsetTask(task.whole, rows.whole[251])
lrn <- makeLearner("regr.rpart")

ps.simple <- mlrCPO::pSS(
  maxdepth: integer[1, 30],
  minsplit: integer[2, 30],
  cp: numeric[0.001, 0.999])
  nRes <- function(n) {
  makeResampleDesc("Subsample", split = 0.9, iters = n)
}

fitness.fun.mos <- makeObjective(lrn, task, ps.simple, nRes,
  measure = mse,
  holdout.data = task.hout, worst.measure = 100)

# extract param set from objective
ps.obj  <- getParamSet(fitness.fun.mos)
getParamIds(ps.obj) # automatically added parameter ' for selecting features

exp <- sampleValue(ps.obj)
res <- fitness.fun.mos(exp, fidelity = 2, holdout = FALSE)


}
