% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_props.R
\name{df_props}
\alias{df_props}
\title{Joint and conditional proportions}
\usage{
df_props(formula, data, as.percent = FALSE, ..., wide = FALSE,
  margins = FALSE, format = c("proportion", "percent", "count"))
}
\arguments{
\item{formula}{the formula describing the relationship}

\item{data}{a data frame (or you can pipe this in)}

\item{as.percent}{show proportions in percent (e.g. multiply by 100)}

\item{...}{statistics functions to be applied to the data, e.g. mean, sd, confidence(0.95)}

\item{wide}{reformat the output as a cross-tabulation. This makes sense only when there are just two variables}

\item{margins}{show the marginal probabilities. Makes the most sense if \code{wide = TRUE}.}

\item{format}{Use just for internal purposes.}
}
\description{
Uses a formula interface to specify how the proportions are to be calculated.
}
\details{
Using \code{|} in the formula specifies a conditional proportion
\itemize{
\item ~ A : proportion of cases in each level of A
\item ~ A + B: joint proportion: each level of A crossed with B
\item ~ A | B: conditional proportion: for each level of B, what fraction are in each level of A
\item A ~ B: another way of specifying the conditional proportion
}
}
\examples{
df_props(mtcars, ~ cyl + gear) 
df_props(mtcars, ~ cyl | gear)
df_props(mtcars, ~ cyl + gear, wide = TRUE)
df_props(mtcars, ~ cyl + gear, margins = TRUE)
df_props(mtcars, ~ cyl | gear, margins = TRUE)

}
