% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequencyPolygon.R
\name{freqpoly}
\alias{freqpoly}
\alias{hist2freqpolygon}
\alias{plot.freqpolygon}
\title{Turn histograms into frequency polygons}
\usage{
freqpoly(x, plot = TRUE, ...)

hist2freqpolygon(hist)

\method{plot}{freqpolygon}(
  x,
  freq = equidist,
  col = graphics::par("fg"),
  lty = NULL,
  lwd = 1,
  main = paste("Frequency polygon of", paste(x$xname, collapse = "\\n")),
  sub = NULL,
  xlab = x$xname,
  ylab,
  xlim = range(x$x),
  ylim = NULL,
  axes = TRUE,
  labels = FALSE,
  add = FALSE,
  ann = TRUE,
  ...
)
}
\arguments{
\item{x}{a vector of values for which a frequency polygon is desired.}

\item{plot}{a logical indicating if a plot should be generated.}

\item{...}{additional arguments passed on to \code{\link[=hist]{hist()}}.}

\item{hist}{a histogram object produced by \code{link{hist}()}.}

\item{freq}{A logical indicating whether the vertical scale should be frequency (count).}

\item{col}{A color for the frequency polygon.}

\item{lty}{An integer indicating the line type.}

\item{lwd}{An integer indicating the line width.}

\item{main}{A title for the plot.}

\item{sub}{A sub-title for the plot.}

\item{xlab}{Label for the horizontal axis.}

\item{ylab}{Label for the vertical axis.}

\item{xlim}{A numeric vector of length 2.}

\item{ylim}{A numeric vector of length 2.}

\item{axes}{A logical indicating whether axes should be drawn.}

\item{labels}{A logical indicating whether labels should be printed or a character
vector of labels to add.}

\item{add}{A logical indicating whether the plot should be added to the current plot}

\item{ann}{A logical indicating whether annotations (titles and axis titles) should be plotted.}
}
\value{
An object of class \code{"freqpoly"} (invisibly).  Additionally, if \code{plot} is
\code{TRUE}, a plot is generated.
}
\description{
Turn histograms into frequency polygons
}
\examples{
freqpoly(faithful$eruptions)
bks <- c(0, 1, 1.5, 2, 3, 3.5, 4, 4.5, 5, 7)
hist(faithful$eruptions, breaks = bks)
freqpoly(faithful$eruptions, col = rgb(0,0,1,.5), lwd = 5, breaks = bks, add = TRUE)

}
