% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varianceAnalysis.R
\name{varianceAnalysis}
\alias{varianceAnalysis}
\title{Variance analysis of RasterStack objects}
\usage{
varianceAnalysis(predictions, component1, component2, fixed = NULL)
}
\arguments{
\item{predictions}{listed lists of raster objects as returned by \code{\link[mopa]{mopaPredict}}}

\item{component1}{Character. Options are "SP", "PA", "SDM", "baseClim" and "newClim" (see Details). If exist, "foldModel" is 
another option. Selected option corresponds to the first component in 
the variance analysis.}

\item{component2}{Character. Options are "SP", "PA", "SDM", "baseClim" and "newClim" (see Details). If exist, "foldModel" is 
another option. Selected option corresponds to the second component in 
the variance analysis.}

\item{fixed}{Optional. Character of the component names corresponding to the components that are not being 
analyzed (component3, component4...). One name for each component is provided, components that only have one choice 
(e.g. a single species, a single baseline climate, etc.) are internally fixed.
 If \code{fixed = NULL} the first element of each component is selected.
If \code{fixed} is specified, the selected name must be provided for each of the components that have multi-choices.}
}
\value{
A list of two RasterStack objects, the first containing the global mean and standard deviation and the 
second containing the percentage of variance correponding to each component in the analysis 
(component1, component2 and components 1 and 2).
}
\description{
Extract componets of lists of objects 
(as returned by function \code{\link[mopa]{mopaPredict}}) 
and perform variance analysis to obtain raster objects of the 
contribution of each component to the observed varaibility.
}
\details{
Rasters are extracted using function \code{\link[base]{grep}}, by matching
names in the lists and characters in \code{componen1} and \code{componen2}. 
The contribution of componen1 in front component2 to the spread (uncertainty) of the projected probabilities 
in \code{predictions} is here assessed using a simple analysis of variance approach, where the total 
variance (V) can be decomposed as the summation of the variance explained by component1 (Vcomp1), 
component2 (Vcomp2) and the combination of the previous two (Vcomp12):

\eqn{V = Vcomp1 + Vcomp2 + Vcomp12}.

Description of the components:
\itemize{
\item{SP:} presence data sets 
\item{PA:} pseudo-absence realizations 
\item{SDM:} modeling algorithms 
\item{baseClim:} bseline climate, i.e. sets of vaiables used for model calibration in function
 \code{\link[mopa]{mopaTrain}}, 
\item{newClim:} new climate, i.e. sets of vaiables used to project models (e.g. future climate projections) in
function \code{\link[mopa]{mopaPredict}} .
}
}
\examples{

## Load climate data
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Fitted models
data(mods)
?mods

## Model prediction and analysis of the variability in projections
newClim <- lapply(1:4, function(x){
crop(biostack$future[[x]], extent(-10, 5, 35, 60))
})

prdRS.fut <- mopaPredict(models = mods, newClim = newClim)
result <- varianceAnalysis(prdRS.fut, "PA", "newClim")
spplot(result$variance, col.regions = rev(get_col_regions()))
}
\references{
San Martin, D., Manzanas, R., Brands, S., Herrera, S., & Gutierrez, J.M. (2016) Reassessing 
Model Uncertainty for Regional Projections of Precipitation with an Ensemble of Statistical Downscaling Methods. 
Journal of Climate 30, 203-223.
}
\seealso{
\code{\link[mopa]{varianceSummary}}
}
\author{
M. Iturbide
}
