% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liewi_gpa.R
\docType{data}
\name{liewi_gpa}
\alias{liewi_gpa}
\title{Array data of Generalized Procrustes Analysis (GPA) coordinates of dorsal anchors of \emph{Ligophorus liewi} samples}
\format{An array of 31 matrices, each having 11 rows (landmarks) and 2 columns (xy GPA coordinates)}
\source{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.
}
\usage{
data(liewi_gpa)
}
\description{
An array data of GPA coordinates of dorsal anchors (left-right averaged) from 31 \emph{Ligophorus liewi} samples.
}
\details{
All samples in this array have quality score above 10.
}
\examples{
data(liewi_gpa)

nice_title <- expression(paste("Dorsal anchor ", italic(L.liewi)))
plotLM(liewi_gpa, tit=nice_title, pointscale=0.8, axispointscale=0.8,
meansize=1.2, polygon.outline=TRUE,c(-.6,.6),c(-.6,.6) )
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\seealso{
\code{\link{Qscore}}, \code{\link{plotLM}}
}
\keyword{datasets}

