% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_get_opt_param.R
\name{mf_get_opt_param}
\alias{mf_get_opt_param}
\title{Precompute the parameter \code{opt_param} of the function \link{mf_get_url}}
\usage{
mf_get_opt_param(collection, roi, credentials = NULL, verbose = "inform")
}
\arguments{
\item{collection}{string. mandatory. Collection of interest (see details of \link{mf_get_url}).}

\item{roi}{object of class \code{sf}. mandatory. Area of region of interest. Must be a Simple feature collection with geometry type POLYGON, composed of one or several rows (i.e. one or several ROIs), and with at least two columns: 'id' (an identifier for the roi) and 'geom' (the geometry).}

\item{credentials}{vector string of length 2 with username and password. optional if the function \link{mf_login} was previously executed.}

\item{verbose}{string. Verbose mode ("quiet", "inform", or "debug"). Default "inform".}
}
\value{
a list with the following named objects :
\describe{
 \item{roiSpatialIndexBound}{OPeNDAP indices for the spatial coordinates of the bounding box of the ROI (minLat, maxLat, minLon, maxLon)}
 \item{availableVariables}{Variables available for the collection of interest}
 \item{roiSpatialBound}{The spatial coordinates of the bounding box of the ROI expressed in the CRS of the collection}
 \item{OpenDAPXVector}{The X (longitude) vector}
 \item{OpenDAPYVector}{The Y (longitude) vector}
 \item{OpenDAPtimeVector}{The time vector, or NULL if the collection does not have a time vector}
 \item{modis_tile}{The MODIS tile(s) number(s) for the ROI or NULL if the collection is not MODIS}
}
}
\description{
Precompute the parameter \code{opt_param} to further provide as input of the \link{mf_get_url} function. Useful to speed-up the overall processing time.
}
\details{
When it is needed to loop the function \link{mf_get_url} over several time frames, it is advised to previously run the function \code{mf_get_opt_param} and provide the output as input \code{opt_param} parameter of the \link{mf_get_url} function.
This will save much time, as internal parameters will be calculated only once.
}
\examples{
\dontrun{

# Login to Earthdata

log <- mf_login(credentials = c("earthdata_un", "earthdata_pw"))

# Get the optional parameters for the collection MOD11A1.061 and the following roi :
roi <- sf::st_as_sf(
  data.frame(
    id = "roi_test",
    geom = "POLYGON ((-5.82 9.54, -5.42 9.55, -5.41 8.84, -5.81 8.84, -5.82 9.54))"
  ),
  wkt = "geom", crs = 4326
)

opt_param_mod11a1 <- mf_get_opt_param("MOD11A1.061", roi)
str(opt_param_mod11a1)

# Now we can provide opt_param_mod11a1 as input parameter of the function mf_get_url().

time_ranges <- list(
  as.Date(c("2016-01-01", "2016-01-31")),
  as.Date(c("2017-01-01", "2017-01-31")),
  as.Date(c("2018-01-01", "2018-01-31")),
  as.Date(c("2019-01-01", "2019-01-31"))
)

(urls_mod11a1 <- map(.x = time_ranges, ~ mf_get_url(
  collection = "MOD11A1.061",
  variables = c("LST_Day_1km", "LST_Night_1km", "QC_Day", "QC_Night"),
  roi = roi,
  time_range = .x,
  opt_param = opt_param_mod11a1
)))
}
}
