% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmky.R
\name{mmky}
\alias{mmky}
\title{Modified Mann-Kendall Test For Serially Correlated Data Using Yue and Wang (2004) Variance Correction Approach.}
\usage{
mmky(x)
}
\arguments{
\item{x}{- Time series data vector}
}
\value{
Corrected Zc  - Z-Statistic after variance Correction

new P.value  - P-Value after variance correction

N/N*  - Effective sample size

Original Z  - Original Mann-Kendall Z-Statistic

Old P-value  - Original Mann-Kendall P-Value

Tau  - Mann-Kendall's Tau

Sen's Slope  - Sen's slope

old.variance - Old variance before variance Correction

new.variance - Variance after correction
}
\description{
Time series data is often influenced by serial-correlation. When data is not random and influenced by auto-correlation, Modified Mann-Kendall tests are to be used in trend detction. Yue and Wang (2004) have proposed variance correction approach to address the issue of serial correlation in Trend analysis. Trend is removed from the series and effective sample size is calculated using significant serial correlation coefficients.
}
\examples{
x<-c(Nile)
mmky(x)

}
\references{
Mann, H. B. (1945). Nonparametric Tests Against Trend. Econometrica, 13(3), 245–259. <doi:10.1017/CBO9781107415324.004>.

Kendall, M. (1975). Multivariate analysis. Charles Griffin. Londres. 0-85264-234-2.

sen, P. K. (1968). Estimates of the Regression Coefficient Based on Kendall’s Tau. Journal of the American statistical Association, 63(324), 1379. <doi:10.2307/2285891>.

Yue, S., & Wang, C. Y. (2004). The Mann-Kendall test modified by effective sample size to detect trend in serially correlated hydrological series. Water Resources Management, 18(3), 201–218. <doi:10.1023/B:WARM.0000043140.61082.60>.
}
