% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{envoy_flights}
\alias{envoy_flights}
\title{Envoy Air flights data for 2023}
\format{
A data frame of 357 rows representing Alaska Airlines flights and 19 variables
\describe{
\item{year, month, day}{Date of departure.}
\item{dep_time, arr_time}{Actual departure and arrival times (format HHMM or HMM), local tz.}
\item{sched_dep_time, sched_arr_time}{Scheduled departure and arrival times (format HHMM or HMM), local tz.}
\item{dep_delay, arr_delay}{Departure and arrival delays, in minutes.
Negative times represent early departures/arrivals.}
\item{carrier}{Two letter carrier abbreviation. See \code{\link[nycflights23:airlines]{nycflights23::airlines}}
to get name.}
\item{flight}{Flight number.}
\item{tailnum}{Plane tail number. See \code{\link[nycflights23:planes]{nycflights23::planes}} for additional metadata.}
\item{origin, dest}{Origin and destination. See \code{\link[nycflights23:airports]{nycflights23::airports}} for
additional metadata.}
\item{air_time}{Amount of time spent in the air, in minutes.}
\item{distance}{Distance between airports, in miles.}
\item{hour, minute}{Time of scheduled departure broken into hour and minutes.}
\item{time_hour}{Scheduled date and hour of the flight as a \code{POSIXct} date.
Along with \code{origin}, can be used to join flights data to \code{\link[nycflights23:weather]{nycflights23::weather}} data.}
}
}
\source{
RITA, Bureau of transportation statistics
}
\usage{
envoy_flights
}
\description{
On-time data for all Envoy Air flights that departed NYC (i.e. JFK, LGA or EWR)
in 2023. This is a subset of the \code{flights} data frame from \code{nycflights23}.
}
\seealso{
\code{\link[nycflights23:flights]{nycflights23::flights}}.
}
\keyword{datasets}
