% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moderndive.R
\docType{package}
\name{moderndive}
\alias{moderndive}
\alias{moderndive-package}
\title{moderndive - Tidyverse-Friendly Introductory Linear Regression}
\description{
Datasets and wrapper functions for tidyverse-friendly introductory linear
regression, used in ModernDive: An Introduction to Statistical and Data
Sciences via R available at \url{https://moderndive.com/} and DataCamp's
Modeling with Data in the Tidyverse available at
\url{https://www.datacamp.com/courses/modeling-with-data-in-the-tidyverse}.
}
\examples{
library(moderndive)

# Fit regression model:
mpg_model <- lm(mpg ~ hp, data = mtcars)

# Regression tables:
get_regression_table(mpg_model)

# Information on each point in a regression:
get_regression_points(mpg_model)

# Regression summaries
get_regression_summaries(mpg_model)
}
