% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-accuracy-table.R
\name{table_modeltime_accuracy}
\alias{table_modeltime_accuracy}
\title{Interactive Accuracy Tables}
\usage{
table_modeltime_accuracy(
  .data,
  .round_digits = 2,
  .sortable = TRUE,
  .show_sortable = TRUE,
  .searchable = TRUE,
  .filterable = FALSE,
  .expand_groups = TRUE,
  .title = "Accuracy Table",
  .interactive = TRUE,
  ...
)
}
\arguments{
\item{.data}{A \code{tibble} that is the output of \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}}

\item{.round_digits}{Rounds accuracy metrics to a specified number of digits.
If \code{NULL}, rounding is not performed.}

\item{.sortable}{Allows sorting by columns.
Only applied to \code{reactable} tables.
Passed to \code{reactable(sortable)}.}

\item{.show_sortable}{Shows sorting.
Only applied to \code{reactable} tables.
Passed to \code{reactable(showSortable)}.}

\item{.searchable}{Adds search input.
Only applied to \code{reactable} tables.
Passed to \code{reactable(searchable)}.}

\item{.filterable}{Adds filters to table columns.
Only applied to \code{reactable} tables.
Passed to \code{reactable(filterable)}.}

\item{.expand_groups}{Expands groups dropdowns.
Only applied to \code{reactable} tables.
Passed to \code{reactable(defaultExpanded)}.}

\item{.title}{A title for static (\code{gt}) tables.}

\item{.interactive}{Return interactive or static tables. If \code{TRUE},
returns \code{reactable} table. If \code{FALSE}, returns static \code{gt} table.}

\item{...}{Additional arguments passed to \code{\link[reactable:reactable]{reactable::reactable()}}
or \code{\link[gt:gt]{gt::gt()}} (depending on \code{.interactive} selection).}
}
\value{
A static \code{gt} table or an interactive \code{reactable} table containing
the accuracy information.
}
\description{
Converts results from \code{\link[=modeltime_accuracy]{modeltime_accuracy()}} into
either interactive (\code{reactable}) or static (\code{gt}) tables.
}
\details{
\strong{Groups}

The function respects \code{dplyr::group_by()} groups and thus scales with multiple groups.

\strong{Reactable Output}

A \code{reactable()} table is an interactive format that enables live searching and sorting.
When \code{.interactive = TRUE}, a call is made to  \code{\link[reactable:reactable]{reactable::reactable()}}.

\code{table_modeltime_accuracy()} includes several common options like toggles for sorting and searching.
Additional arguments can be passed to \code{\link[reactable:reactable]{reactable::reactable()}} via \code{...}.

\strong{GT Output}

A \code{gt} table is an HTML-based table that is "static" (e.g. non-searchable, non-sortable). It's
commonly used in PDF and Word documents that does not support interactive content.

When \code{.interactive = FALSE}, a call is made to \code{\link[gt:gt]{gt::gt()}}. Arguments can be passed via \code{...}.

Table customization is implemented using a piping workflow (\verb{\%>\%}).
For more information, refer to the \href{https://gt.rstudio.com/index.html}{GT Documentation}.
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)
library(modeltime)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.9)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- ACCURACY ----

models_tbl \%>\%
    modeltime_calibrate(new_data = testing(splits)) \%>\%
    modeltime_accuracy() \%>\%
    table_modeltime_accuracy()


}
