% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-accuracy.R
\name{default_forecast_accuracy_metric_set}
\alias{default_forecast_accuracy_metric_set}
\title{Forecast Accuracy Metrics Sets}
\usage{
default_forecast_accuracy_metric_set(...)
}
\arguments{
\item{...}{Add additional \code{yardstick} metrics}
}
\description{
This is a wrapper for \code{\link[=metric_set]{metric_set()}} with several common forecast / regression
accuracy metrics included. These are the default time series accuracy
metrics used with \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}.
}
\details{
The primary purpose is to use the default accuracy metrics to calculate the following
forecast accuracy metrics using \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}:
\itemize{
\item MAE   - Mean absolute error, \code{\link[=mae]{mae()}}
\item MAPE  - Mean absolute percentage error, \code{\link[=mape]{mape()}}
\item MASE  - Mean absolute scaled error, \code{\link[=mase]{mase()}}
\item SMAPE - Symmetric mean absolute percentage error, \code{\link[=smape]{smape()}}
\item RMSE  - Root mean squared error, \code{\link[=rmse]{rmse()}}
\item RSQ   - R-squared, \code{\link[=rsq]{rsq()}}
}

Adding additional metrics is possible via \code{...}.
}
\examples{
library(tibble)
library(dplyr)
library(timetk)
library(yardstick)

fake_data <- tibble(
    y    = c(1:12, 2*1:12),
    yhat = c(1 + 1:12, 2*1:12 - 1)
)

# ---- HOW IT WORKS ----

# Default Forecast Accuracy Metric Specification
default_forecast_accuracy_metric_set()

# Create a metric summarizer function from the metric set
calc_default_metrics <- default_forecast_accuracy_metric_set()

# Apply the metric summarizer to new data
calc_default_metrics(fake_data, y, yhat)

# ---- ADD MORE PARAMETERS ----

# Can create a version of mase() with seasonality = 12 (monthly)
mase12 <- metric_tweak(.name = "mase12", .fn = mase, m = 12)

# Add it to the default metric set
my_metric_set <- default_forecast_accuracy_metric_set(mase12)
my_metric_set

# Apply the newly created metric set
my_metric_set(fake_data, y, yhat)


}
\seealso{
\itemize{
\item \code{\link[yardstick:metric_tweak]{yardstick::metric_tweak()}} - For modifying \code{yardstick} metrics
}
}
