% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-timetk.R
\name{time_series_cv}
\alias{time_series_cv}
\alias{time_series_split}
\alias{plot_time_series_cv_plan}
\alias{tk_time_series_cv_plan}
\title{Time Series Resampling Sets and Plans}
\description{
These resampling tools are exported from the \code{timetk} package.
\itemize{
\item \code{\link[timetk:time_series_cv]{timetk::time_series_cv()}}: Creates resample sets using time series cross validation
\item \code{\link[timetk:time_series_split]{timetk::time_series_split()}}: Makes an initial time series split
\item \code{\link[timetk:plot_time_series_cv_plan]{timetk::plot_time_series_cv_plan()}}: Plots a cross validation plan
\item \code{\link[timetk:tk_time_series_cv_plan]{timetk::tk_time_series_cv_plan()}}: Unnests a cross validation plan
}
}
\examples{

# Generate Time Series Resamples
resamples_tscv <- time_series_cv(
    data        = m750,
    assess      = "2 years",
    initial     = "5 years",
    skip        = "2 years",
    slice_limit = 4
)

resamples_tscv

# Visualize the Resample Sets
resamples_tscv \%>\%
    tk_time_series_cv_plan() \%>\%
    plot_time_series_cv_plan(
        date, value,
        .facet_ncol  = 2,
        .interactive = FALSE
    )

}
\keyword{internal}
