
<!-- README.md is generated from README.Rmd. Please edit that file -->

# modeltime.h2o <img src='man/figures/logo.png' align="right" height="138" />

<!-- badges: start -->

[![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/modeltime.h2o)](https://cran.r-project.org/package=modeltime.h2o)
![](http://cranlogs.r-pkg.org/badges/modeltime.h2o?color=brightgreen)
![](http://cranlogs.r-pkg.org/badges/grand-total/modeltime.h2o?color=brightgreen)
[![Codecov test
coverage](https://codecov.io/gh/business-science/modeltime.h2o/branch/master/graph/badge.svg)](https://codecov.io/gh/business-science/modeltime.h2o?branch=master)
[![R-CMD-check](https://github.com/business-science/modeltime.h2o/workflows/R-CMD-check/badge.svg)](https://github.com/business-science/modeltime.h2o/actions)
<!-- badges: end -->

> Forecasting with H2O AutoML

Modeltime H2O provides an H2O backend to the Modeltime Forecasting
Ecosystem. The main algorithm is **H2O AutoML**, an automatic machine
learning library that is built for speed and scale.

``` r
# Install Development Version
devtools::install_github("business-science/modeltime.h2o")
```

## What’s possible

With the Modeltime Ecosystem, it’s easy to forecast at scale. This
forecast was created with **H2O AutoML**. Try it out in [Getting Started
with Modeltime
H2O](https://business-science.github.io/modeltime.h2o/articles/getting-started.html).

<img src="man/figures/h2o_forecast_plot.png" width="100%" />

## Meet the modeltime ecosystem

> Learn a growing ecosystem of forecasting packages

<div class="figure" style="text-align: center">

<img src="man/figures/modeltime_ecosystem.jpg" alt="The modeltime ecosystem is growing" width="100%" />
<p class="caption">
The modeltime ecosystem is growing
</p>

</div>

Modeltime is part of a **growing ecosystem** of Modeltime forecasting
packages.

-   [Modeltime (Machine
    Learning)](https://business-science.github.io/modeltime/)

-   [Modeltime H2O
    (AutoML)](https://business-science.github.io/modeltime.h2o/)

-   [Modeltime GluonTS (Deep
    Learning)](https://business-science.github.io/modeltime.gluonts/)

-   [Modeltime Ensemble (Blending
    Forecasts)](https://business-science.github.io/modeltime.ensemble/)

-   [Modeltime Resample
    (Backtesting)](https://business-science.github.io/modeltime.resample/)

-   [Timetk (Feature Engineering, Data Wrangling, Time Series
    Visualization)](https://business-science.github.io/timetk/)

## Take the High-Performance Forecasting Course

> Become the forecasting expert for your organization

<a href="https://university.business-science.io/p/ds4b-203-r-high-performance-time-series-forecasting/" target="_blank"><img src="https://www.filepicker.io/api/file/bKyqVAi5Qi64sS05QYLk" alt="High-Performance Time Series Forecasting Course" width="100%" style="box-shadow: 0 0 5px 2px rgba(0, 0, 0, .5);"/></a>

[*High-Performance Time Series
Course*](https://university.business-science.io/p/ds4b-203-r-high-performance-time-series-forecasting/)

### Time Series is Changing

Time series is changing. **Businesses now need 10,000+ time series
forecasts every day.** This is what I call a *High-Performance Time
Series Forecasting System (HPTSF)* - Accurate, Robust, and Scalable
Forecasting.

**High-Performance Forecasting Systems will save companies by improving
accuracy and scalability.** Imagine what will happen to your career if
you can provide your organization a “High-Performance Time Series
Forecasting System” (HPTSF System).

### How to Learn High-Performance Time Series Forecasting

I teach how to build a HPTFS System in my [**High-Performance Time
Series Forecasting
Course**](https://university.business-science.io/p/ds4b-203-r-high-performance-time-series-forecasting).
You will learn:

-   **Time Series Machine Learning** (cutting-edge) with `Modeltime` -
    30+ Models (Prophet, ARIMA, XGBoost, Random Forest, & many more)
-   **Deep Learning** with `GluonTS` (Competition Winners)
-   **Time Series Preprocessing**, Noise Reduction, & Anomaly Detection
-   **Feature engineering** using lagged variables & external regressors
-   **Hyperparameter Tuning**
-   **Time series cross-validation**
-   **Ensembling** Multiple Machine Learning & Univariate Modeling
    Techniques (Competition Winner)
-   **Scalable Forecasting** - Forecast 1000+ time series in parallel
-   and more.

<p class="text-center" style="font-size:24px;">
Become the Time Series Expert for your organization.
</p>
<br>
<p class="text-center" style="font-size:30px;">
<a href="https://university.business-science.io/p/ds4b-203-r-high-performance-time-series-forecasting">Take
the High-Performance Time Series Forecasting Course</a>
</p>
