% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{simple_kmeans_db}
\alias{simple_kmeans_db}
\title{Simple kmeans routine that works in-database}
\usage{
simple_kmeans_db(df, ..., centers = 3, max_repeats = 100,
  initial_kmeans = NULL, safeguard_file = "kmeans.csv",
  verbose = TRUE)
}
\arguments{
\item{df}{A Local or remote data frame}

\item{...}{A list of variables to be used in the kmeans algorithm}

\item{centers}{The number of centers. Defaults to 3.}

\item{max_repeats}{The maximum number of cycles to run. Defaults to 100.}

\item{initial_kmeans}{A local dataframe with initial centroid values. Defaults to NULL.}

\item{safeguard_file}{Each cycle will update a file specified in this argument 
with the current centers.  Defaults to 'kmeans.csv'. Pass NULL if no file is 
desired.}

\item{verbose}{Indicates if the progress bar will be displayed during the model's fitting.}
}
\description{
It uses 'tidyeval' and 'dplyr' to run multiple cycles of kmean
calculations, expressed in dplyr formulas until an the optimal
centers are found.
}
\details{
Because each cycle is an independent 'dplyr' operation, or SQL operation if using a remote source,
the latest centroid data frame is saved to the parent environment in case the process needs to be
canceled and then restarted at a later point.  Passing the `current_kmeans` as the `initial_kmeans`
will allow the operation to pick up where it left off.
}
\examples{
library(dplyr)

mtcars \%>\%
  simple_kmeans_db(mpg, qsec, wt) \%>\%
  glimpse()

}
