% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reexports.R,
%   R/visualisation_recipe.estimate_grouplevel.R,
%   R/visualisation_recipe.estimate_means.R,
%   R/visualisation_recipe.estimate_predicted.R,
%   R/visualisation_recipe.estimate_slopes.R
\docType{import}
\name{reexports}
\alias{reexports}
\alias{visualisation_recipe}
\alias{visualisation_recipe.estimate_grouplevel}
\alias{visualisation_recipe.estimate_means}
\alias{visualisation_recipe.estimate_predicted}
\alias{visualisation_recipe.estimate_slopes}
\title{Objects exported from other packages}
\usage{
\method{visualisation_recipe}{estimate_grouplevel}(
  x,
  hline = NULL,
  pointrange = NULL,
  facet_wrap = NULL,
  labs = NULL,
  ...
)

\method{visualisation_recipe}{estimate_means}(
  x,
  show_data = "jitter",
  point = NULL,
  jitter = point,
  boxplot = NULL,
  violin = NULL,
  line = NULL,
  pointrange = NULL,
  labs = NULL,
  ...
)

\method{visualisation_recipe}{estimate_predicted}(
  x,
  show_data = "points",
  point = NULL,
  density_2d = NULL,
  line = NULL,
  ribbon = NULL,
  labs = NULL,
  ...
)

\method{visualisation_recipe}{estimate_slopes}(
  x,
  hline = NULL,
  line = NULL,
  pointrange = NULL,
  ribbon = NULL,
  labs = NULL,
  facet_wrap = NULL,
  ...
)
}
\arguments{
\item{x}{A modelbased object.}

\item{...}{Other arguments passed to other functions.}

\item{show_data}{Display the "raw" data as a background to the model-based estimation. Can be set to \code{"none"} to remove it. When input is the result of \code{estimate_means}, \code{show_data} can be "points" (the jittered observation points), "boxplot", "violin" a combination of them (see examples). When input is the result of \code{estimate_response} or \code{estimate_relation}, \code{show_data} can be "points" (the points of the original data corresponding to the x and y axes), "density_2d", "density_2d_filled", "density_2d_polygon" or "density_2d_raster".}

\item{point, jitter, boxplot, violin, pointrange, density_2d, line, hline, ribbon, labs, facet_wrap}{Additional aesthetics and parameters for the geoms (see customization example).}
}
\examples{
# ==============================================
# estimate_grouplevel
# ==============================================
if (require("see") && require("lme4")) {
  data <- lme4::sleepstudy
  data <- rbind(data, data)
  data$Newfactor <- rep(c("A", "B", "C", "D"))

  # 1 random intercept
  model <- lmer(Reaction ~ Days + (1 | Subject), data = data)
  x <- estimate_grouplevel(model)
  layers <- visualisation_recipe(x)
  layers
  plot(layers)

}
\donttest{
if (require("see") && require("lme4")) {

  # 2 random intercepts
  model <- lmer(Reaction ~ Days + (1 | Subject) + (1 | Newfactor), data = data)
  x <- estimate_grouplevel(model)
  plot(visualisation_recipe(x))


  model <- lmer(Reaction ~ Days + (1 + Days | Subject) + (1 | Newfactor), data = data)
  x <- estimate_grouplevel(model)
  plot(visualisation_recipe(x))
}
}
# ==============================================
# estimate_means
# ==============================================
if (require("ggplot2")) {

  # Simple Model ---------------
  x <- estimate_means(lm(Sepal.Width ~ Species, data = iris))
  layers <- visualisation_recipe(x)
  layers
  plot(layers)

}
\donttest{
if (require("ggplot2")) {

  # Customize aesthetics
  layers <- visualisation_recipe(x,
    jitter = list(width = 0.03, color = "red"),
    line = list(linetype = "dashed")
  )
  plot(layers)

  # Customize raw data
  plot(visualisation_recipe(x, show_data = c("violin", "boxplot", "jitter")))

  # Two levels ---------------
  data <- mtcars
  data$cyl <- as.factor(data$cyl)
  data$new_factor <- as.factor(rep(c("A", "B"), length.out = nrow(mtcars)))

  model <- lm(mpg ~ new_factor * cyl * wt, data = data)
  x <- estimate_means(model, at = c("new_factor", "cyl"))
  plot(visualisation_recipe(x))

  # Modulations --------------
  x <- estimate_means(model, at = c("new_factor", "wt"))
  plot(visualisation_recipe(x))

  x <- estimate_means(model, at = c("new_factor", "cyl", "wt"))
  plot(visualisation_recipe(x))

  #'   # GLMs ---------------------
  data <- data.frame(vs = mtcars$vs, cyl = as.factor(mtcars$cyl))
  x <- estimate_means(glm(vs ~ cyl, data = data, family = "binomial"))
  plot(visualisation_recipe(x))
}
}
# ==============================================
# estimate_relation, estimate_response, ...
# ==============================================
if (require("ggplot2")) {

  # Simple Model ---------------
  x <- estimate_relation(lm(mpg ~ wt, data = mtcars))
  layers <- visualisation_recipe(x)
  layers
  plot(layers)

}
\donttest{
if (require("ggplot2")) {

  # Customize aesthetics
  layers <- visualisation_recipe(x,
    point = list(color = "red", alpha = 0.6, size = 3),
    line = list(color = "blue", size = 4),
    ribbon = list(fill = "green", alpha = 0.7),
    labs = list(subtitle = "Oh yeah!")
  )
  layers
  plot(layers)

  # Customize raw data
  plot(visualisation_recipe(x, show_data = "none"))
  plot(visualisation_recipe(x, show_data = c("density_2d", "points")))
  plot(visualisation_recipe(x, show_data = "density_2d_filled"))
  plot(visualisation_recipe(x, show_data = "density_2d_polygon"))
  plot(visualisation_recipe(x, show_data = "density_2d_raster")) +
    scale_x_continuous(expand = c(0, 0)) +
    scale_y_continuous(expand = c(0, 0))

  # 2-ways interaction ------------

  # Numeric * numeric
  x <- estimate_relation(lm(mpg ~ wt * qsec, data = mtcars))
  layers <- visualisation_recipe(x)
  plot(layers)

  # Factor * numeric
  x <- estimate_relation(lm(Sepal.Width ~ Species * Sepal.Length, data = iris))
  layers <- visualisation_recipe(x)
  plot(layers)

  # 3-ways interaction ------------

  data <- mtcars
  data$vs <- as.factor(data$vs)
  data$cyl <- as.factor(data$cyl)
  data$new_factor <- as.factor(rep(c("A", "B"), length.out = nrow(mtcars)))

  # Numeric * numeric * numeric
  x <- estimate_relation(lm(mpg ~ wt * qsec * hp, data = data))
  layers <- visualisation_recipe(x)
  plot(layers)

  # Numeric * numeric * factor
  x <- estimate_relation(lm(mpg ~ wt * am * vs, data = data))
  layers <- visualisation_recipe(x)
  plot(layers)

  # Numeric * factor * factor
  x <- estimate_relation(lm(mpg ~ wt * cyl * new_factor, data = data))
  layers <- visualisation_recipe(x)
  plot(layers)

  # GLMs ---------------------
  x <- estimate_relation(glm(vs ~ mpg, data = mtcars, family = "binomial"))
  plot(visualisation_recipe(x))
  plot(visualisation_recipe(x, show_data = "jitter", point = list(height = 0.03)))

  # Multiple CIs ---------------------
  x <- estimate_relation(lm(mpg ~ disp, data = mtcars), ci = c(.50, .80, .95))
  plot(x)
}

# Bayesian models ---------------------
if (require("ggplot2") && require("rstanarm")) {
  model <- rstanarm::stan_glm(mpg ~ wt, data = mtcars, refresh = 0)

  # Plot individual draws instead of regular ribbon
  x <- estimate_relation(model, keep_iterations = TRUE)
  layers <- visualisation_recipe(x, ribbon = list(color = "red"))
  plot(layers)

  model <- rstanarm::stan_glm(Sepal.Width ~ Species * Sepal.Length, data = iris, refresh = 0)
  plot(estimate_relation(model, keep_iterations = TRUE))
}
}
# ==============================================
# estimate_slopes
# ==============================================
if (require("ggplot2")) {
  model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)
  x <- estimate_slopes(model, trend = "Petal.Length", at = "Species")

  layers <- visualisation_recipe(x)
  layers
  plot(layers)

  model <- lm(Petal.Length ~ poly(Sepal.Width, 4), data = iris)
  x <- estimate_slopes(model, at = "Sepal.Width", length = 20)
  plot(visualisation_recipe(x))

  model <- lm(Petal.Length ~ Species * poly(Sepal.Width, 3), data = iris)
  x <- estimate_slopes(model, at = c("Sepal.Width", "Species"))
  plot(visualisation_recipe(x))
}
\donttest{
if (require("mgcv")) {
  data <- iris
  data$Petal.Length <- data$Petal.Length^2

  model <- mgcv::gam(Sepal.Width ~ t2(Petal.Width, Petal.Length), data = data)
  x <- estimate_slopes(model, at = c("Petal.Width", "Petal.Length"), length = 20)
  plot(visualisation_recipe(x))

  model <- mgcv::gam(Sepal.Width ~ t2(Petal.Width, Petal.Length, by = Species), data = data)
  x <- estimate_slopes(model, at = c("Petal.Width", "Petal.Length", "Species"), length = 10)
  plot(visualisation_recipe(x))
}
}
}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{datawizard}{\code{\link[datawizard]{visualisation_recipe}}}
}}

