% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity_Area_Relationships.R
\name{dist_decay}
\alias{dist_decay}
\title{Distance decay of similarity}
\usage{
dist_decay(
  comm,
  prop_area = 0.005,
  n_samples = 20,
  method = "bray",
  binary = F
)
}
\arguments{
\item{comm}{\code{\link{community}} object}

\item{prop_area}{Subplot size as proportion of the total area}

\item{n_samples}{Number of randomly located subplots}

\item{method}{Choice of (dis)similarity index. See \code{\link[vegan]{vegdist}}}

\item{binary}{Perform presence/absence standardization before analysis?
See \code{\link[vegan]{vegdist}}}
}
\value{
Dataframe with distances between subplot pairs and the respective
similarity indices
}
\description{
Estimate pairwise similarities of communities in subplots as
function of distance
}
\examples{
sim_com1 <- sim_thomas_community(100, 10000, sigma = 0.1, mother_points = 2)
dd1 <- dist_decay(sim_com1, prop_area = 0.005, n_samples = 20)
plot(dd1)

}
