% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr.R
\name{subset.mob_in}
\alias{subset.mob_in}
\title{Subset the rows of the mob data input object}
\usage{
\method{subset}{mob_in}(x, subset, type = "string", drop_levels = FALSE, ...)
}
\arguments{
\item{x}{an object of class mob_in created by \code{\link{make_mob_in}}}

\item{subset}{expression indicating elements or rows to keep: missing values are taken as false.}

\item{type}{specifies the type of object the argument \code{subset}
specifies, may be: \code{string}, \code{integer}, or \code{logical},
defaults to \code{string}}

\item{drop_levels}{Boolean if TRUE unused levels are removed from factors in
mob_in$env}

\item{...}{parameters passed to other functions}
}
\description{
This function subsets the rows of comm, env, and spat attributes of the
mob_in object
}
\examples{
 data(inv_comm)
 data(inv_plot_attr)
 inv_mob_in = make_mob_in(inv_comm, inv_plot_attr, coord_names = c('x', 'y'))
 subset(inv_mob_in, group == 'invaded')
 subset(inv_mob_in, 1:4, type='integer')
 subset(inv_mob_in, 1:4, type='integer', drop_levels=TRUE)
 sub_log = c(TRUE, FALSE, TRUE, rep(FALSE, nrow(inv_mob_in$comm) - 3))
 subset(inv_mob_in, sub_log, type='logical')
}
