% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplement.funct.R
\name{densi.curv.cop}
\alias{densi.curv.cop}
\title{Computes the density of level curves for copulae models}
\usage{
densi.curv.cop(lines, copi, pxf, pyf, u)
}
\arguments{
\item{lines}{location of the objective level curve for which the density needs to be estimated in the 2D space}

\item{copi}{a copula function with the parameters fitted to the bivariate dataset}

\item{pxf}{uniform values of the 1st margin}

\item{pyf}{uniform values of the 1st margin}

\item{u}{original data}
}
\value{
density for each points (couple x,y) along the level curves for copulae
}
\description{
Computes the density along the level curve estimate with a copula.
Based on the density function of the selected copula.
}
\examples{
data(porto)

tr1=0.9
tr2=0.9
fire01meantemp=na.omit(fire01meantemp)
u=fire01meantemp

#Compute uniform margins
marg=Margins.mod(tr1,tr2,u=fire01meantemp)
kk=marg$uvar
pp=marg$uvar_ext
uu=marg$val_ext

#Copula parameters
c1=1.5
copu<-copBasic::GHcop
upobj=0.001
interh="comb"

#compute the curve on 3 subdomains
cl1<-curve.funct(pxf=pp[,1],pyf=pp[,2],mar1=uu[,1],mar2=uu[,2],pos="l",
pobje=upobj,ng=100,inter=interh,coco=copu,c1=c1)
cl2<-curve.funct(pxf=pp[,1],pyf=pp[,2],mar1=uu[,1],mar2=uu[,2],pos="m",
pobje=upobj,ng=100,inter=interh,coco=copu,c1=c1)
cl3<-curve.funct(pxf=pp[,1],pyf=pp[,2],mar1=uu[,1],mar2=uu[,2],pos="r",
pobje=upobj,ng=100,inter=interh,coco=copu,c1=c1)

cl<-rbind(cl1,cl2,cl3)

# Homogenization of the number of points
cli<-digit.curves.p(start=c(cl[1,1],cl[1,2]), as.matrix(cl), nPoints=98, closed = FALSE)

# Computes the density along the curve
co=copula::gumbelCopula(c1,dim=2)
cli<-densi.curv.cop(lines=cli,copi=co,pxf=kk[,1],pyf=kk[,2],u=u)
}
\seealso{
\code{\link[copula]{dcopula}}
}
