% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual.plot.R
\name{residual.plot}
\alias{residual.plot}
\title{Produces two plots: a) histogram of residuals, b) predicted Vs residuals.
This feature is applicable only when linear regression is considered as the
node model.}
\usage{
residual.plot(object, breaks = 50)
}
\arguments{
\item{object}{An object of class 'mobforest.output'}

\item{breaks}{Integer for number of breaks in histogram}
}
\description{
Residuals are computed as difference between the predicted values of
outcome (summarized across all trees) and observed values of outcome. The
residual plots are typical when the fitted values are obtained through
linear regression but not when logistic or Poisson regression is considered
as a node model. Therefore, the residual plots are produced only when
linear regression is considered. For logistic or Poisson models, a message
is printed saying "Residual Plot not produced when logistic of Poisson
regression is considered as the node model".
}
\examples{
\dontrun{
library(mlbench)
set.seed(1111)
# Random Forest analysis of model based recursive partitioning load data
data("BostonHousing", package = "mlbench")
BostonHousing <- BostonHousing[1:90, c("rad", "tax", "crim", "medv", "lstat")]

# Recursive partitioning based on linear regression model medv ~ lstat with 3
# trees.  1 core/processor used. 
rfout <- mobforest.analysis(as.formula(medv ~ lstat), c("rad", "tax", "crim"),
    mobforest_controls = mobforest.control(ntree = 3, mtry = 2, replace = T,
        alpha = 0.05, bonferroni = T, minsplit = 25), data = BostonHousing,
    processors = 1, model = linearModel, seed = 1111)
# get predictive performance estimates and produce a performance plot
residualPlot(rfout)
}

}
