% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_mps_on_date.R
\name{mnis_mps_on_date}
\alias{mnis_mps_on_date}
\title{mnis_mps_on_date}
\usage{
mnis_mps_on_date(date1 = Sys.Date(), date2 = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{date1}{The date to return the list of mps from. Accepts character values in "YYYY-MM-DD" format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}. Defaults to current system date.}

\item{date2}{An optional query parameter. Accepts character values in "YYYY-MM-DD" format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}. If not NULL, the function returns a list of all MPs who were members between date2 and date1. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove extra characters, superfluous text and convert variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy=TRUE. Accepts one of "snake_case", "camelCase" and "period.case". Defaults to "snake_case".}
}
\value{
A tibble with information on all MPs who were members of the House of Commons on the date specificed (if only date1 is included as a parameter), or on or between the two dates if both date1 and date2 are specified.
}
\description{
mnis_mps_on_date
}
\examples{
\dontrun{

x <- mnis_mps_on_date()

}
}
