% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{getCPOOperatingType}
\alias{getCPOOperatingType}
\alias{OperatingType}
\title{Determine the Operating Type of the CPO}
\usage{
getCPOOperatingType(cpo)
}
\arguments{
\item{cpo}{[\code{\link{CPO}} | \code{\link{CPOTrained}}]\cr
The CPO, Retrafo, or Inverter to inspect.}
}
\value{
[\code{character(1)}]. Zero or more of \dQuote{target}, \dQuote{feature}, \dQuote{retrafoless}.
}
\description{
Gives the \emph{operating type} of a CPO or Retrafo, i.e. the part of a given data set it operates on.
This can be \dQuote{target} for a CPO / Retrafo / Inverter that
manipulates target columns, \dQuote{feature} for
a CPO / Retrafo that manipulates non-target columns,
or \dQuote{retrafoless} for a CPO that only handles training data
(and hence can manipulate both feature and target columns, but produces no retrafo).

For a composite CPO / Retrafo of different operating types, all
types are returned. \code{NULLCPO} has no operating type.
}
\section{Operating types}{

There are three types of \code{\link{CPO}} that differ in their effects on the data: \dQuote{\emph{Feature Operation}},
\dQuote{\emph{Target Operation}}, and \dQuote{\emph{Retrafoless}}.

Feature Operation CPOs (\bold{FOCPO}) only change the feature columns
of a data set, and don't change the target column(s). They therefore cannot change the type of a \code{\link[mlr]{Task}}, and
will never change the number of rows of a data set. They are the easiest CPO to handle, as they do not require
inversion of predictions made with processed data. Examples of Feature Operation CPOs is the scaling of individual features
to have unit variance (\code{\link{cpoScale}}), or the projection on principal components (\code{\link{cpoPca}}).

Target Operation CPOs (\bold{TOCPO}) only change the target column(s) of a data set, not the feature columns. They can thus
also change the type
of a \code{\link[mlr]{Task}}, and the \link{PredictType}s admitted by a \code{\link[mlr:makeLearner]{Learner}}. They are thus a powerful
instrument, but they are harder to handle, since predictions made with data sets processed with this kind of CPO need to be
\emph{inverted} using the \code{\link{invert}} function and possibly an \code{\link{CPOInverter}} object (see documentation there).
(Note that attaching a Target Operation CPO to a \code{\link[mlr:makeLearner]{Learner}} will hide this complexity from the user and is the
recommended way of handling it.)
Examples of Target Operation CPOs are the log-transformation of the target column of a regression task, the conversion of a
binary classification task into a 0-1-regression task, or the substitution of the target values into the residuals after a
\code{\link[mlr:makeLearner]{Learner}} was applied to the task. Note that the last of these examples distinguishes itself by the fact that
the inversion operation is dependent on the \emph{prediction} data used. While for the first two examples, the
\code{\link{CPORetrafo}} object can be used for inversionk, the last one requires the \code{\link{CPOInverter}} object. See
\code{\link{CPOTrainedCapability}} for more on this.

Retrafoless CPOs (\bold{ROCPO}) can change the feature \emph{and} target columns of a task, but this comes at the cost of not
allowing retransformations. When getting the
\code{\link{CPORetrafo}} object using \code{\link{retrafo}}, one will always get an identity transformation.
While other CPOs can be understood as \emph{transforming} the space of features or target values,
respectively, the Retrafoless CPO can only \emph{add} or \emph{subtract} points in the given space. Examples of this operation
are subsampling and supersampling.
}

\seealso{
Other getters and setters: 
\code{\link{CPO}},
\code{\link{getCPOAffect}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOConstructor}()},
\code{\link{getCPOId}()},
\code{\link{getCPOName}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{setCPOId}()}

Other retrafo related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.retrafo}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other inverter related: 
\code{\link{CPOTrained}},
\code{\link{NULLCPO}},
\code{\link{\%>>\%}()},
\code{\link{applyCPO}()},
\code{\link{as.list.CPO}},
\code{\link{clearRI}()},
\code{\link{getCPOClass}()},
\code{\link{getCPOName}()},
\code{\link{getCPOPredictType}()},
\code{\link{getCPOProperties}()},
\code{\link{getCPOTrainedCPO}()},
\code{\link{getCPOTrainedCapability}()},
\code{\link{getCPOTrainedState}()},
\code{\link{is.inverter}()},
\code{\link{makeCPOTrainedFromState}()},
\code{\link{pipeCPO}()},
\code{\link{print.CPOConstructor}()}

Other CPO classifications: 
\code{\link{CPO}},
\code{\link{getCPOClass}()},
\code{\link{getCPOTrainedCapability}()}
}
\concept{CPO classifications}
\concept{getters and setters}
\concept{inverter related}
\concept{retrafo related}
