% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{identicalCPO}
\alias{identicalCPO}
\title{Check Whether Two CPO are Fundamentally the Same}
\usage{
identicalCPO(cpo1, cpo2)
}
\arguments{
\item{cpo1}{[\code{\link{CPO}}]\cr
The \code{\link{CPO}} to compare.}

\item{cpo2}{[\code{\link{CPO}}]\cr
The \code{\link{CPO}} to compare.}
}
\value{
[\code{logical(1)}]. \code{TRUE} if the \code{\link{CPO}}s are fundamentally
  the same.
}
\description{
Check whether two \code{\link{CPO}} perform the same operation. This
compares the inner workings of a \code{\link{CPO}}, but not the hyperparameter,
hyperparameter-export, or \code{affect.*} settings of the \code{\link{CPO}}.

Internally, this checks whether the \code{\link{CPOConstructor}} used to create
the two \code{\link{CPO}}s is identical. When creating new \code{\link{CPOConstructor}}s with
\code{\link{makeCPO}} and related functions, it may be necessary to overload this function,
if the resulting \code{\link{CPO}}s should be differentiated in a different way.

This function is used in \code{\link{cpoCbind}} to check for equality of underlying
\code{\link{CPO}}s.
}
\seealso{
Other CPO lifecycle related: \code{\link{CPOConstructor}},
  \code{\link{CPOLearner}}, \code{\link{CPOTrained}},
  \code{\link{CPO}}, \code{\link{NULLCPO}},
  \code{\link{\%>>\%}}, \code{\link{attachCPO}},
  \code{\link{composeCPO}}, \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOTrainedCPO}}, \code{\link{makeCPO}}

Other CPOConstructor related: \code{\link{CPOConstructor}},
  \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOName}}, \code{\link{makeCPO}},
  \code{\link{print.CPOConstructor}}
}
