% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoTuner.R
\name{AutoTuner}
\alias{AutoTuner}
\title{AutoTuner}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:Learner]{mlr3::Learner}.}
\description{
The \code{AutoTuner} is a \link[mlr3:Learner]{mlr3::Learner} which auto-tunes by first tuning the hyperparameters of its encapsulated learner
on the training data, then setting the optimal configuration in the learner, then finally
fitting the model on the complete training data.
Note that this class allows to perform nested resampling by passing an \link{AutoTuner} object to \code{\link[mlr3:resample]{mlr3::resample()}}
or \code{\link[mlr3:benchmark]{mlr3::benchmark()}}.
}
\section{Construction}{
\preformatted{at = AutoTuner$new(learner, resampling, measures, tune_ps, terminator, tuner, bm_args = list())
}
\itemize{
\item \code{learner} :: \link[mlr3:Learner]{mlr3::Learner}\cr
Learner to tune, see \link{TuningInstance}.
\item \code{resampling} :: \link[mlr3:Resampling]{mlr3::Resampling}\cr
Resampling strategy during tuning, see \link{TuningInstance}.
This \link[mlr3:Resampling]{mlr3::Resampling} is meant to be the \strong{inner} resampling, operating on the training set
of an arbitrary outer resampling.
For this reason it is not feasible to pass an instantiated \link[mlr3:Resampling]{mlr3::Resampling} here.
\item \code{measures} :: list of \link[mlr3:Measure]{mlr3::Measure}\cr
Performance measures. The first one is optimized, see \link{TuningInstance}.
\item \code{tune_ps} :: \link[paradox:ParamSet]{paradox::ParamSet}\cr
Hyperparameter search space, see \link{TuningInstance}.
\item \code{terminator} :: \link{Terminator}\cr
When to stop tuning, see \link{TuningInstance}.
\item \code{tuner} :: \link{Tuner}\cr
Tuning algorithm to run.
\item \code{bm_args} :: \code{list()}\cr
Further arguments for \code{\link[mlr3:benchmark]{mlr3::benchmark()}}, see \link{TuningInstance}.
}
}

\section{Fields}{

All fields from \link{Learner}, and additionally:
\itemize{
\item \code{instance_args} :: \code{list}
All arguments from construction to create the \link{TuningInstance}.
\item \code{tuner} :: \link{Tuner}; from construction.
\item \code{store_tuning_instance} :: \code{logical(1)}\cr
If \code{TRUE}, stores the internally created \link{TuningInstance} with all intermediate results in slot \verb{$tuning_instance}.
By default, this is \code{TRUE}.
\item \code{learner} :: \link[mlr3:Learner]{mlr3::Learner}
Trained learner
\item \code{tuning_instance} :: \link{TuningInstance}\cr
Internally created tuning instance with all intermediate results.
\item \code{tuning_result} :: named \code{list}\cr
Short-cut to \code{result} from \link{TuningInstance}.
}
}

\section{Methods}{

All methods from \link{Learner}, and additionally:
\itemize{
\item \code{archive(unnest = "params")}\cr
\code{character(1)} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Short-cut to method from \link{TuningInstance}.
}
}

\examples{
library(mlr3)
library(paradox)
task = tsk("iris")
learner = lrn("classif.rpart")
resampling = rsmp("holdout")
measures = msr("classif.ce")
param_set = ParamSet$new(
  params = list(ParamDbl$new("cp", lower = 0.001, upper = 0.1)))

terminator = term("evals", n_evals = 5)
tuner = tnr("grid_search")
at = AutoTuner$new(learner, resampling, measures, param_set, terminator, tuner)
at$store_tuning_instance = TRUE

at$train(task)
at$model
at$learner
}
\concept{Learner}
