context("TerminatorCombo")

test_that("API", {
  t1 = term("evals", n_evals = 2)
  t2 = term("perf_reached", level = 0)

  tt = term("combo", terminators = list(t1, t2), any = TRUE)
  inst = TEST_MAKE_INST1(measures = msr("dummy.cp.classif"))
  inst$eval_batch(data.table(cp = 0.2))
  expect_false(t1$is_terminated(inst))
  expect_false(t2$is_terminated(inst))
  expect_false(tt$is_terminated(inst))
  inst$eval_batch(data.table(cp = 0.1))
  expect_true(t1$is_terminated(inst))
  expect_false(t2$is_terminated(inst))
  expect_true(tt$is_terminated(inst))


  tt = term("combo", terminators = list(t1, t2), any = FALSE)
  inst = TEST_MAKE_INST1(measures = msr("dummy.cp.classif"))
  inst$eval_batch(data.table(cp = 0.2))
  expect_false(t1$is_terminated(inst))
  expect_false(t2$is_terminated(inst))
  expect_false(tt$is_terminated(inst))
  inst$eval_batch(data.table(cp = 0.1))
  expect_true(t1$is_terminated(inst))
  expect_false(t2$is_terminated(inst))
  expect_false(tt$is_terminated(inst))
  inst$eval_batch(data.table(cp = 0))
  expect_true(t1$is_terminated(inst))
  expect_true(t2$is_terminated(inst))
  expect_true(tt$is_terminated(inst))
})
