% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingSpCVDisc.R
\name{mlr_resamplings_spcv_disc}
\alias{mlr_resamplings_spcv_disc}
\alias{ResamplingSpCVDisc}
\title{(sperrorest) Spatial "disc" resampling}
\description{
Spatial partitioning using circular test areas of one of more observations.
Optionally, a buffer around the test area can be used to exclude observations.
See the upstream implementation at \code{sperrorest::partition_disc()} and
Brenning (2012) for further information.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{radius} (\code{numeric(1)})\cr
Radius of test area disc.
\item \code{buffer} (\code{integer(1)})\cr
Radius around test area disc which is excluded from training or test set.
\item \code{prob} (\code{integer(1)})\cr
Optional argument passed down to \code{sample()}.
\item \code{replace} (\code{logical(1)})\cr
Optional argument passed down to \code{sample()}. Sample with or without
replacement.
}
}

\examples{
library(mlr3)
task = tsk("ecuador")

# Instantiate Resampling
rcv = rsmp("spcv_disc", folds = 3L, radius = 200L, buffer = 200L)
rcv$instantiate(task)

# Individual sets:
rcv$train_set(1)
rcv$test_set(1)
# check that no obs are in both sets
intersect(rcv$train_set(1), rcv$test_set(1)) # good!

# Internal storage:
rcv$instance # table
}
\references{
Brenning A (2012).
\dQuote{Spatial cross-validation and bootstrap for the assessment of prediction rules in remote sensing: The R package sperrorest.}
In \emph{2012 IEEE International Geoscience and Remote Sensing Symposium}.
\doi{10.1109/igarss.2012.6352393}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingSpCVDisc}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingSpCVDisc-new}{\code{ResamplingSpCVDisc$new()}}
\item \href{#method-ResamplingSpCVDisc-instantiate}{\code{ResamplingSpCVDisc$instantiate()}}
\item \href{#method-ResamplingSpCVDisc-clone}{\code{ResamplingSpCVDisc$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVDisc-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVDisc-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spatial 'Disc' resampling" resampling instance.

For a list of available arguments, please see
\link[sperrorest:partition_disc]{sperrorest::partition_disc}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVDisc$new(id = "spcv_disc")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVDisc-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVDisc-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVDisc$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link{Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingSpCVDisc-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingSpCVDisc-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingSpCVDisc$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
