% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_ovr.R
\name{mlr_graphs_ovr}
\alias{mlr_graphs_ovr}
\alias{pipeline_ovr}
\title{Create A Graph to Perform "One vs. Rest" classification.}
\usage{
pipeline_ovr(graph)
}
\arguments{
\item{graph}{\code{\link{Graph}} \cr
Graph being wrapped between \code{\link{PipeOpOVRSplit}} and \code{\link{PipeOpOVRUnite}}.
The Graph should return \code{NULL} during training and a
\link[mlr3:PredictionClassif]{classification Prediction} during prediction.}
}
\value{
\code{\link{Graph}}
}
\description{
Create a new \code{\link{Graph}} for a \link[mlr3:TaskClassif]{classification Task} to
perform "One vs. Rest" classification.

All input arguments are cloned and have no references in common with the returned \code{\link{Graph}}.
}
\examples{
\dontshow{if (requireNamespace("rpart")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")

task = tsk("wine")

learner = lrn("classif.rpart")
learner$predict_type = "prob"

# Simple OVR
g1 = pipeline_ovr(learner)
g1$train(task)
g1$predict(task)

# Bagged Learners
gr = po("replicate", reps = 3) \%>>\%
  po("subsample") \%>>\%
  learner \%>>\%
  po("classifavg", collect_multiplicity = TRUE)
g2 = pipeline_ovr(gr)
g2$train(task)
g2$predict(task)

# Bagging outside OVR
g3 = po("replicate", reps = 3) \%>>\%
  pipeline_ovr(po("subsample") \%>>\% learner) \%>>\%
  po("classifavg", collect_multiplicity = TRUE)
g3$train(task)
g3$predict(task)
\dontshow{\}) # examplesIf}
}
