% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_oml_tasks.R
\name{list_oml_tasks}
\alias{list_oml_tasks}
\title{List Tasks from OpenML}
\usage{
list_oml_tasks(
  task_id = NULL,
  number_instances = NULL,
  number_features = NULL,
  number_classes = NULL,
  number_missing_values = NULL,
  tag = NULL,
  limit = 5000L,
  ...
)
}
\arguments{
\item{task_id}{(\code{integer()})\cr
Vector of task ids to restrict to.}

\item{number_instances}{(\code{integer()})\cr
Filter for number of instances.}

\item{number_features}{(\code{integer()})\cr
Filter for number of features.}

\item{number_classes}{(\code{integer()})\cr
Filter for number of labels of the target (only classification tasks).}

\item{number_missing_values}{(\code{integer()})\cr
Filter for number of missing values.}

\item{tag}{(\code{character()})\cr
Filter for specific tag. You can provide multiple tags as character vector.}

\item{limit}{(\code{integer()})\cr
Limit the results to \code{limit} records.
Default is 5000.}

\item{...}{(any)\cr
Additional filters as named arguments.}
}
\value{
(\code{data.table()}) of results, or \code{NULL} if no data set matches the criteria.
}
\description{
This function allows to find tasks on \url{https://openml.org/t} using
some simple filter criteria.

Note that only a subset of filters is exposed here.
For a more feature-complete package, see \CRANpkg{OpenML}.
}
\details{
Filter values can be provided as single atomic values (typically integer or character).
Provide a numeric vector of length 2 (\code{c(l, u)}) to find matches in the range \eqn{[l, u]}.
}
\examples{
\donttest{
list_oml_tasks(number_instances = 150, number_features = c(1, 10))
}
}
\references{
\cite{mlr3oml}{openml-r}

\cite{mlr3oml}{vanschoren2014}
}
