% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_acc.R
\name{acc}
\alias{acc}
\title{Classification Accuracy}
\usage{
acc(truth, response, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{(\code{factor()})\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
labels
in multiclass classification tasks.
}
\details{
The Classification Accuracy is defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n w_i \left( t_i = r_i \right).
}{
  weighted.mean(t == r, w).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
acc(truth, response)
}
\seealso{
Other Classification Measures: 
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mauc_aunu}()},
\code{\link{mbrier}()},
\code{\link{zero_one}()}
}
\concept{Classification Measures}
\concept{classification_measure}
