% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_bias.R
\name{bias}
\alias{bias}
\title{Bias}
\usage{
bias(truth, response, sample_weights = NULL, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
The Bias is defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n w_i \left( t_i - r_i \right).
}{
  weighted.mean(t - r, w).
}
Good predictions score close to 0.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{(-\infty, \infty)}{(-Inf, Inf)}
\item Minimize: \code{NA}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
bias(truth, response)
}
\seealso{
Other Regression Measures: 
\code{\link{ktau}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
